/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.BlockContent;
import com.vladsch.flexmark.ast.CodeBlock;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.internal.BlockQuoteParser;
import com.vladsch.flexmark.internal.HeadingParser;
import com.vladsch.flexmark.internal.HtmlBlockParser;
import com.vladsch.flexmark.internal.IndentedCodeBlockParser;
import com.vladsch.flexmark.internal.ListBlockParser;
import com.vladsch.flexmark.internal.ThematicBreakParser;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FencedCodeBlockParser
extends AbstractBlockParser {
    private static final Pattern OPENING_FENCE = Pattern.compile("^`{3,}(?!.*`)|^~{3,}(?!.*~)");
    private static final Pattern CLOSING_FENCE = Pattern.compile("^(?:`{3,}|~{3,})(?=[ \t]*$)");
    private final FencedCodeBlock block = new FencedCodeBlock();
    private BlockContent content = new BlockContent();
    private char fenceChar;
    private int fenceLength;
    private int fenceIndent;
    private int fenceMarkerIndent;
    private final boolean matchingCloser;
    private final boolean codeContentBlock;

    public FencedCodeBlockParser(DataHolder options, char fenceChar, int fenceLength, int fenceIndent, int fenceMarkerIndent) {
        this.fenceChar = fenceChar;
        this.fenceLength = fenceLength;
        this.fenceIndent = fenceIndent;
        this.fenceMarkerIndent = fenceIndent + fenceMarkerIndent;
        this.matchingCloser = (Boolean)options.get(Parser.MATCH_CLOSING_FENCE_CHARACTERS);
        this.codeContentBlock = (Boolean)options.get(Parser.FENCED_CODE_CONTENT_BLOCK);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    public int getFenceIndent() {
        return this.fenceIndent;
    }

    public int getFenceMarkerIndent() {
        return this.fenceMarkerIndent;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int foundFenceLength;
        BasedSequence trySequence;
        Matcher matcher;
        boolean matches;
        int nextNonSpace = state.getNextNonSpaceIndex();
        int newIndex = state.getIndex();
        BasedSequence line = state.getLine();
        boolean bl = matches = state.getIndent() <= 3 && nextNonSpace < line.length() && (!this.matchingCloser || line.charAt(nextNonSpace) == this.fenceChar);
        if (matches && (matcher = CLOSING_FENCE.matcher((CharSequence)(trySequence = line.subSequence(nextNonSpace, line.length())))).find() && (foundFenceLength = matcher.group(0).length()) >= this.fenceLength) {
            this.block.setClosingMarker(trySequence.subSequence(0, foundFenceLength));
            return BlockContinue.finished();
        }
        for (int i = this.fenceIndent; i > 0 && newIndex < line.length() && line.charAt(newIndex) == ' '; ++newIndex, --i) {
        }
        return BlockContinue.atIndex(newIndex);
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    @Override
    public boolean isPropagatingLastBlankLine(BlockParser lastMatchedBlockParser) {
        return false;
    }

    @Override
    public void closeBlock(ParserState state) {
        List lines = this.content.getLines();
        if (lines.size() > 0) {
            BasedSequence info = (BasedSequence)lines.get(0);
            if (!info.isBlank()) {
                this.block.setInfo(info.trim());
            }
            BasedSequence chars = this.content.getSpanningChars();
            BasedSequence spanningChars = chars.baseSubSequence(chars.getStartOffset(), ((BasedSequence)lines.get(0)).getEndOffset());
            if (lines.size() > 1) {
                List segments = lines.subList(1, lines.size());
                this.block.setContent(spanningChars, segments);
                if (this.codeContentBlock) {
                    CodeBlock codeBlock = new CodeBlock();
                    codeBlock.setContent(segments);
                    codeBlock.setCharsFromContent();
                    this.block.appendChild((Node)codeBlock);
                } else {
                    Text codeBlock = new Text(SegmentedSequence.of(segments, (BasedSequence)chars.subSequence(0, 0)));
                    this.block.appendChild(codeBlock);
                }
            } else {
                this.block.setContent(spanningChars, BasedSequence.EMPTY_LIST);
            }
        } else {
            this.block.setContent(this.content);
        }
        this.block.setCharsFromContent();
        this.content = null;
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private BlockFactory(DataHolder options) {
            super(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence line = state.getLine();
            if (state.getIndent() < 4) {
                BasedSequence trySequence = line.subSequence(nextNonSpace, line.length());
                Matcher matcher = OPENING_FENCE.matcher((CharSequence)trySequence);
                if (matcher.find()) {
                    int fenceLength = matcher.group(0).length();
                    char fenceChar = matcher.group(0).charAt(0);
                    FencedCodeBlockParser blockParser = new FencedCodeBlockParser((DataHolder)state.getProperties(), fenceChar, fenceLength, state.getIndent(), nextNonSpace);
                    blockParser.block.setOpeningMarker(trySequence.subSequence(0, fenceLength));
                    return BlockStart.of(blockParser).atIndex(nextNonSpace + fenceLength);
                }
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class));
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return new HashSet<Class<? extends CustomBlockParserFactory>>(Arrays.asList(HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class, IndentedCodeBlockParser.Factory.class));
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

