/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http1.HeadersReader;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public final class Http1ExchangeCodec
implements ExchangeCodec {
    public static final Companion Companion = new Companion(null);
    private final OkHttpClient client;
    private final RealConnection connection;
    private final BufferedSource source;
    private final BufferedSink sink;
    private int state;
    private final HeadersReader headersReader;
    private Headers trailers;

    public Http1ExchangeCodec(OkHttpClient client, RealConnection connection, BufferedSource source2, BufferedSink sink2) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(sink2, "sink");
        this.client = client;
        this.connection = connection;
        this.source = source2;
        this.sink = sink2;
        this.headersReader = new HeadersReader(this.source);
    }

    @Override
    public RealConnection getConnection() {
        return this.connection;
    }

    private final boolean isChunked(Response $this$isChunked) {
        return StringsKt.equals("chunked", Response.header$default($this$isChunked, "Transfer-Encoding", null, 2, null), true);
    }

    private final boolean isChunked(Request $this$isChunked) {
        return StringsKt.equals("chunked", $this$isChunked.header("Transfer-Encoding"), true);
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) {
        Sink sink2;
        Intrinsics.checkNotNullParameter(request, "request");
        if (request.body() != null && request.body().isDuplex()) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if (this.isChunked(request)) {
            sink2 = this.newChunkedSink();
        } else if (contentLength != -1L) {
            sink2 = this.newKnownLengthSink();
        } else {
            throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
        }
        return sink2;
    }

    @Override
    public void cancel() {
        this.getConnection().cancel();
    }

    @Override
    public void writeRequestHeaders(Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Proxy.Type type = this.getConnection().route().proxy().type();
        Intrinsics.checkNotNullExpressionValue((Object)type, "connection.route().proxy.type()");
        String requestLine = RequestLine.INSTANCE.get(request, type);
        this.writeRequest(request.headers(), requestLine);
    }

    @Override
    public long reportedContentLength(Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return !HttpHeaders.promisesBody(response) ? 0L : (this.isChunked(response) ? -1L : Util.headersContentLength(response));
    }

    @Override
    public Source openResponseBodySource(Response response) {
        long contentLength;
        Intrinsics.checkNotNullParameter(response, "response");
        return !HttpHeaders.promisesBody(response) ? this.newFixedLengthSource(0L) : (this.isChunked(response) ? this.newChunkedSource(response.request().url()) : ((contentLength = Util.headersContentLength(response)) != -1L ? this.newFixedLengthSource(contentLength) : this.newUnknownLengthSource()));
    }

    @Override
    public void flushRequest() {
        this.sink.flush();
    }

    @Override
    public void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(Headers headers, String requestLine) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(requestLine, "requestLine");
        if (!(this.state == 0)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus("state: ", this.state);
            throw new IllegalStateException(string.toString());
        }
        this.sink.writeUtf8(requestLine).writeUtf8("\r\n");
        int n = 0;
        int n2 = headers.size();
        while (n < n2) {
            int i = n++;
            this.sink.writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    @Override
    public Response.Builder readResponseHeaders(boolean expectContinue) {
        if (!(this.state == 1 || this.state == 2 || this.state == 3)) {
            boolean $i$a$-check-Http1ExchangeCodec$readResponseHeaders$22 = false;
            String $i$a$-check-Http1ExchangeCodec$readResponseHeaders$22 = Intrinsics.stringPlus("state: ", this.state);
            throw new IllegalStateException($i$a$-check-Http1ExchangeCodec$readResponseHeaders$22.toString());
        }
        try {
            Response.Builder builder;
            StatusLine statusLine = StatusLine.Companion.parse(this.headersReader.readLine());
            Response.Builder responseBuilder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.headersReader.readHeaders());
            if (expectContinue && statusLine.code == 100) {
                builder = null;
            } else if (statusLine.code == 100) {
                this.state = 3;
                builder = responseBuilder;
            } else {
                int n = statusLine.code;
                boolean bl = 102 <= n ? n < 200 : false;
                if (bl) {
                    this.state = 3;
                    builder = responseBuilder;
                } else {
                    this.state = 4;
                    builder = responseBuilder;
                }
            }
            return builder;
        }
        catch (EOFException e) {
            String address = this.getConnection().route().address().url().redact();
            throw new IOException(Intrinsics.stringPlus("unexpected end of stream on ", address), e);
        }
    }

    private final Sink newChunkedSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus("state: ", this.state);
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new ChunkedSink();
    }

    private final Sink newKnownLengthSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus("state: ", this.state);
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new KnownLengthSink();
    }

    private final Source newFixedLengthSource(long length) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus("state: ", this.state);
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new FixedLengthSource(length);
    }

    private final Source newChunkedSource(HttpUrl url) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus("state: ", this.state);
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new ChunkedSource(url);
    }

    private final Source newUnknownLengthSource() {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus("state: ", this.state);
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        this.getConnection().noNewExchanges$okhttp();
        return new UnknownLengthSource();
    }

    private final void detachTimeout(ForwardingTimeout timeout2) {
        Timeout oldDelegate = timeout2.delegate();
        timeout2.setDelegate(Timeout.NONE);
        oldDelegate.clearDeadline();
        oldDelegate.clearTimeout();
    }

    public final void skipConnectBody(Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        long contentLength = Util.headersContentLength(response);
        if (contentLength == -1L) {
            return;
        }
        Source body = this.newFixedLengthSource(contentLength);
        Util.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        body.close();
    }

    private final class KnownLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;

        public KnownLengthSink() {
            Intrinsics.checkNotNullParameter(Http1ExchangeCodec.this, "this$0");
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer source2, long byteCount) {
            Intrinsics.checkNotNullParameter(source2, "source");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            Util.checkOffsetAndCount(source2.size(), 0L, byteCount);
            Http1ExchangeCodec.this.sink.write(source2, byteCount);
        }

        @Override
        public void flush() {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    private final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;

        public ChunkedSink() {
            Intrinsics.checkNotNullParameter(Http1ExchangeCodec.this, "this$0");
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(Buffer source2, long byteCount) {
            Intrinsics.checkNotNullParameter(source2, "source");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (byteCount == 0L) {
                return;
            }
            Http1ExchangeCodec.this.sink.writeHexadecimalUnsignedLong(byteCount);
            Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
            Http1ExchangeCodec.this.sink.write(source2, byteCount);
            Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
        }

        @Override
        public synchronized void flush() {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.sink.writeUtf8("0\r\n\r\n");
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    private abstract class AbstractSource
    implements Source {
        private final ForwardingTimeout timeout;
        private boolean closed;

        public AbstractSource() {
            Intrinsics.checkNotNullParameter(Http1ExchangeCodec.this, "this$0");
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.source.timeout());
        }

        protected final boolean getClosed() {
            return this.closed;
        }

        protected final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public long read(Buffer sink2, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter(sink2, "sink");
            try {
                l = Http1ExchangeCodec.this.source.read(sink2, byteCount);
            }
            catch (IOException e) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
                throw e;
            }
            return l;
        }

        public final void responseBodyComplete() {
            if (Http1ExchangeCodec.this.state == 6) {
                return;
            }
            if (Http1ExchangeCodec.this.state != 5) {
                throw new IllegalStateException(Intrinsics.stringPlus("state: ", Http1ExchangeCodec.this.state));
            }
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 6;
        }
    }

    private final class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        public FixedLengthSource(long bytesRemaining) {
            Intrinsics.checkNotNullParameter(Http1ExchangeCodec.this, "this$0");
            this.bytesRemaining = bytesRemaining;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
        }

        @Override
        public long read(Buffer sink2, long byteCount) {
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22 = Intrinsics.stringPlus("byteCount < 0: ", byteCount);
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long read = super.read(sink2, Math.min(this.bytesRemaining, byteCount));
            if (read == -1L) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw e;
            }
            this.bytesRemaining -= read;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
            return read;
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    private final class ChunkedSource
    extends AbstractSource {
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        public ChunkedSource(HttpUrl url) {
            Intrinsics.checkNotNullParameter(Http1ExchangeCodec.this, "this$0");
            Intrinsics.checkNotNullParameter(url, "url");
            this.url = url;
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
        }

        @Override
        public long read(Buffer sink2, long byteCount) {
            long l;
            long read;
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22 = Intrinsics.stringPlus("byteCount < 0: ", byteCount);
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((read = super.read(sink2, Math.min(byteCount, l = this.bytesRemainingInChunk))) == -1L) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw e;
            }
            this.bytesRemainingInChunk -= read;
            return read;
        }

        private final void readChunkSize() {
            if (this.bytesRemainingInChunk != -1L) {
                Http1ExchangeCodec.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1ExchangeCodec.this.source.readHexadecimalUnsignedLong();
                String extensions = ((Object)StringsKt.trim(Http1ExchangeCodec.this.source.readUtf8LineStrict())).toString();
                if (this.bytesRemainingInChunk < 0L || ((CharSequence)extensions).length() > 0 && !StringsKt.startsWith$default(extensions, ";", false, 2, null)) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + extensions + '\"');
                }
            }
            catch (NumberFormatException e) {
                throw new ProtocolException(e.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                Http1ExchangeCodec.this.trailers = Http1ExchangeCodec.this.headersReader.readHeaders();
                OkHttpClient okHttpClient = Http1ExchangeCodec.this.client;
                Intrinsics.checkNotNull(okHttpClient);
                CookieJar cookieJar = okHttpClient.cookieJar();
                Headers headers = Http1ExchangeCodec.this.trailers;
                Intrinsics.checkNotNull(headers);
                HttpHeaders.receiveHeaders(cookieJar, this.url, headers);
                this.responseBodyComplete();
            }
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    private final class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        public UnknownLengthSource() {
            Intrinsics.checkNotNullParameter(Http1ExchangeCodec.this, "this$0");
        }

        @Override
        public long read(Buffer sink2, long byteCount) {
            Intrinsics.checkNotNullParameter(sink2, "sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22 = Intrinsics.stringPlus("byteCount < 0: ", byteCount);
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long read = super.read(sink2, byteCount);
            if (read == -1L) {
                this.inputExhausted = true;
                this.responseBodyComplete();
                return -1L;
            }
            return read;
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

