/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonPath;

public abstract class AbstractJsonLexer {
    public int currentPosition;
    public final JsonPath path = new JsonPath();
    private String peekedString;
    private StringBuilder escapedString = new StringBuilder();

    protected abstract CharSequence getSource();

    public void ensureHaveChars() {
    }

    public abstract int prefetchOrEof(int var1);

    public abstract boolean canConsumeValue();

    public abstract byte consumeNextToken();

    public final boolean tryConsumeComma() {
        CharSequence source2;
        int current = this.skipWhitespaces();
        if (current >= (source2 = this.getSource()).length() || current == -1) {
            return false;
        }
        if (source2.charAt(current) == ',') {
            ++this.currentPosition;
            return true;
        }
        return false;
    }

    protected final boolean isValidValueStart(char c) {
        boolean bl;
        switch (c) {
            case ',': 
            case ':': 
            case ']': 
            case '}': {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public final void expectEof() {
        byte nextToken = this.consumeNextToken();
        if (nextToken != 10) {
            AbstractJsonLexer.fail$default(this, "Expected EOF after parsing, but had " + this.getSource().charAt(this.currentPosition - 1) + " instead", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    public final byte consumeNextToken(byte expected) {
        byte token = this.consumeNextToken();
        if (token != expected) {
            AbstractJsonLexer.fail$kotlinx_serialization_json$default(this, expected, false, 2, null);
            throw new KotlinNothingValueException();
        }
        return token;
    }

    public abstract void consumeNextToken(char var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void unexpectedToken(char expected) {
        if (this.currentPosition > 0 && expected == '\"') {
            String string;
            AbstractJsonLexer this_$iv = this;
            boolean $i$f$withPositionRollback = false;
            int snapshot$iv = this_$iv.currentPosition;
            try {
                boolean bl = false;
                int n = this.currentPosition;
                this.currentPosition = n + -1;
                string = this.consumeStringLenient();
            }
            finally {
                this_$iv.currentPosition = snapshot$iv;
            }
            String inputLiteral = string;
            if (Intrinsics.areEqual(inputLiteral, "null")) {
                this.fail("Expected string literal but 'null' literal was found", this.currentPosition - 1, "Use 'coerceInputValues = true' in 'Json {}' builder to coerce nulls if property has a default value.");
                throw new KotlinNothingValueException();
            }
        }
        AbstractJsonLexer.fail$kotlinx_serialization_json$default(this, AbstractJsonLexerKt.charToTokenClass(expected), false, 2, null);
        throw new KotlinNothingValueException();
    }

    public final Void fail$kotlinx_serialization_json(byte expectedToken, boolean wasConsumed) {
        String expected = AbstractJsonLexerKt.tokenDescription(expectedToken);
        int position = wasConsumed ? this.currentPosition - 1 : this.currentPosition;
        String s = this.currentPosition == this.getSource().length() || position < 0 ? "EOF" : String.valueOf(this.getSource().charAt(position));
        AbstractJsonLexer.fail$default(this, "Expected " + expected + ", but had '" + s + "' instead", position, null, 4, null);
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void fail$kotlinx_serialization_json$default(AbstractJsonLexer abstractJsonLexer, byte by, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fail");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return abstractJsonLexer.fail$kotlinx_serialization_json(by, bl);
    }

    public byte peekNextToken() {
        CharSequence source2 = this.getSource();
        int cpos = this.currentPosition;
        block3: while ((cpos = this.prefetchOrEof(cpos)) != -1) {
            char ch = source2.charAt(cpos);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++cpos;
                    continue block3;
                }
            }
            this.currentPosition = cpos;
            return AbstractJsonLexerKt.charToTokenClass(ch);
        }
        this.currentPosition = cpos;
        return 10;
    }

    public final boolean tryConsumeNull(boolean doConsume) {
        int current = this.skipWhitespaces();
        current = this.prefetchOrEof(current);
        int len = this.getSource().length() - current;
        if (len < 4 || current == -1) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if ("null".charAt(i) == this.getSource().charAt(current + i)) continue;
            return false;
        }
        if (len > 4 && AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current + 4)) == 0) {
            return false;
        }
        if (doConsume) {
            this.currentPosition = current + 4;
        }
        return true;
    }

    public static /* synthetic */ boolean tryConsumeNull$default(AbstractJsonLexer abstractJsonLexer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tryConsumeNull");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return abstractJsonLexer.tryConsumeNull(bl);
    }

    public abstract int skipWhitespaces();

    public abstract String peekLeadingMatchingValue(String var1, boolean var2);

    public final String peekString(boolean isLenient) {
        String string;
        String string2;
        byte token = this.peekNextToken();
        if (isLenient) {
            if (token != 1 && token != 0) {
                return null;
            }
            string2 = this.consumeStringLenient();
        } else {
            if (token != 1) {
                return null;
            }
            string2 = this.consumeString();
        }
        this.peekedString = string = string2;
        return string;
    }

    public final void discardPeeked() {
        this.peekedString = null;
    }

    public String substring(int startPos, int endPos) {
        return ((Object)this.getSource().subSequence(startPos, endPos)).toString();
    }

    public abstract String consumeKeyString();

    public final String consumeString() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        return this.consumeKeyString();
    }

    protected final String consumeString(CharSequence source2, int startPosition, int current) {
        Intrinsics.checkNotNullParameter(source2, "source");
        int currentPosition = current;
        int lastPosition = startPosition;
        char c = source2.charAt(currentPosition);
        boolean usedAppend = false;
        while (c != '\"') {
            if (c == '\\') {
                usedAppend = true;
                if ((currentPosition = this.prefetchOrEof(this.appendEscape(lastPosition, currentPosition))) == -1) {
                    AbstractJsonLexer.fail$default(this, "Unexpected EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            } else if (++currentPosition >= source2.length()) {
                usedAppend = true;
                this.appendRange(lastPosition, currentPosition);
                currentPosition = this.prefetchOrEof(currentPosition);
                if (currentPosition == -1) {
                    AbstractJsonLexer.fail$default(this, "Unexpected EOF", currentPosition, null, 4, null);
                    throw new KotlinNothingValueException();
                }
                lastPosition = currentPosition;
            }
            c = source2.charAt(currentPosition);
        }
        String string = !usedAppend ? this.substring(lastPosition, currentPosition) : this.decodedString(lastPosition, currentPosition);
        this.currentPosition = currentPosition + 1;
        return string;
    }

    private final int appendEscape(int lastPosition, int current) {
        this.appendRange(lastPosition, current);
        return this.appendEsc(current + 1);
    }

    private final String decodedString(int lastPosition, int currentPosition) {
        this.appendRange(lastPosition, currentPosition);
        String string = this.escapedString.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String result2 = string;
        this.escapedString.setLength(0);
        return result2;
    }

    private final String takePeeked() {
        String string;
        String string2 = this.peekedString;
        Intrinsics.checkNotNull(string2);
        String it = string = string2;
        boolean bl = false;
        this.peekedString = null;
        return string;
    }

    public final String consumeStringLenientNotNull() {
        String result2 = this.consumeStringLenient();
        if (Intrinsics.areEqual(result2, "null") && this.wasUnquotedString()) {
            AbstractJsonLexer.fail$default(this, "Unexpected 'null' value instead of string literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return result2;
    }

    private final boolean wasUnquotedString() {
        return this.getSource().charAt(this.currentPosition - 1) != '\"';
    }

    public final String consumeStringLenient() {
        if (this.peekedString != null) {
            return this.takePeeked();
        }
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", current, null, 4, null);
            throw new KotlinNothingValueException();
        }
        byte token = AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current));
        if (token == 1) {
            return this.consumeString();
        }
        if (token != 0) {
            AbstractJsonLexer.fail$default(this, "Expected beginning of the string, but got " + this.getSource().charAt(current), 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        boolean usedAppend = false;
        while (AbstractJsonLexerKt.charToTokenClass(this.getSource().charAt(current)) == 0) {
            if (++current < this.getSource().length()) continue;
            usedAppend = true;
            this.appendRange(this.currentPosition, current);
            int eof = this.prefetchOrEof(current);
            if (eof == -1) {
                this.currentPosition = current;
                return this.decodedString(0, 0);
            }
            current = eof;
        }
        String result2 = !usedAppend ? this.substring(this.currentPosition, current) : this.decodedString(this.currentPosition, current);
        this.currentPosition = current;
        return result2;
    }

    protected void appendRange(int fromIndex, int toIndex) {
        this.escapedString.append(this.getSource(), fromIndex, toIndex);
    }

    private final int appendEsc(int startPosition) {
        int currentPosition = startPosition;
        if ((currentPosition = this.prefetchOrEof(currentPosition)) == -1) {
            AbstractJsonLexer.fail$default(this, "Expected escape sequence to continue, got EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        char currentChar = this.getSource().charAt(currentPosition++);
        if (currentChar == 'u') {
            return this.appendHex(this.getSource(), currentPosition);
        }
        char c = AbstractJsonLexerKt.escapeToChar(currentChar);
        if (c == '\u0000') {
            AbstractJsonLexer.fail$default(this, "Invalid escaped char '" + currentChar + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        this.escapedString.append(c);
        return currentPosition;
    }

    private final int appendHex(CharSequence source2, int startPos) {
        if (startPos + 4 >= source2.length()) {
            this.currentPosition = startPos;
            this.ensureHaveChars();
            if (this.currentPosition + 4 >= source2.length()) {
                AbstractJsonLexer.fail$default(this, "Unexpected EOF during unicode escape", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            return this.appendHex(source2, this.currentPosition);
        }
        this.escapedString.append((char)((this.fromHexChar(source2, startPos) << 12) + (this.fromHexChar(source2, startPos + 1) << 8) + (this.fromHexChar(source2, startPos + 2) << 4) + this.fromHexChar(source2, startPos + 3)));
        return startPos + 4;
    }

    private final int fromHexChar(CharSequence source2, int currentPosition) {
        int n;
        char character = source2.charAt(currentPosition);
        boolean bl = '0' <= character ? character < ':' : false;
        if (bl) {
            n = character - 48;
        } else {
            boolean bl2 = 'a' <= character ? character < 'g' : false;
            if (bl2) {
                n = character - 97 + 10;
            } else {
                boolean bl3 = 'A' <= character ? character < 'G' : false;
                if (bl3) {
                    n = character - 65 + 10;
                } else {
                    AbstractJsonLexer.fail$default(this, "Invalid toHexChar char '" + character + "' in unicode escape", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
        return n;
    }

    public final void skipElement(boolean allowLenientStrings) {
        List tokenStack = new ArrayList();
        byte lastToken = this.peekNextToken();
        if (lastToken != 8 && lastToken != 6) {
            this.consumeStringLenient();
            return;
        }
        while (true) {
            if ((lastToken = this.peekNextToken()) == 1) {
                String string = allowLenientStrings ? this.consumeStringLenient() : this.consumeKeyString();
                continue;
            }
            byte by = lastToken;
            if (by == 8 || by == 6) {
                tokenStack.add(lastToken);
            } else if (by == 9) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 8) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found ] instead of } at path: " + this.path, this.getSource());
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 7) {
                if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 6) {
                    throw JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found } instead of ] at path: " + this.path, this.getSource());
                }
                CollectionsKt.removeLast(tokenStack);
            } else if (by == 10) {
                AbstractJsonLexer.fail$default(this, "Unexpected end of input due to malformed JSON during ignoring unknown keys", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            this.consumeNextToken();
            if (tokenStack.size() == 0) break;
        }
    }

    public String toString() {
        return "JsonReader(source='" + this.getSource() + "', currentPosition=" + this.currentPosition + ')';
    }

    public final void failOnUnknownKey(String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String processed = this.substring(0, this.currentPosition);
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)processed, key, 0, false, 6, null);
        this.fail("Encountered an unknown key '" + key + '\'', lastIndexOf, "Use 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.");
        throw new KotlinNothingValueException();
    }

    public final Void fail(String message, int position, String hint) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(hint, "hint");
        String hintMessage = ((CharSequence)hint).length() == 0 ? "" : '\n' + hint;
        throw JsonExceptionsKt.JsonDecodingException(position, message + " at path: " + this.path.getPath() + hintMessage, this.getSource());
    }

    public static /* synthetic */ Void fail$default(AbstractJsonLexer abstractJsonLexer, String string, int n, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fail");
        }
        if ((n2 & 2) != 0) {
            n = abstractJsonLexer.currentPosition;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        return abstractJsonLexer.fail(string, n, string2);
    }

    public final long consumeNumericLiteral() {
        long l;
        boolean hasChars;
        boolean bl;
        int current = this.skipWhitespaces();
        if ((current = this.prefetchOrEof(current)) >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            if (++current == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        long accumulator = 0L;
        long exponentAccumulator = 0L;
        boolean isNegative = false;
        boolean isExponentPositive = false;
        boolean hasExponent = false;
        int start = current;
        while (current != this.getSource().length()) {
            char ch = this.getSource().charAt(current);
            if (!(ch != 'e' && ch != 'E' || hasExponent)) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol " + ch + " in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = true;
                hasExponent = true;
                ++current;
                continue;
            }
            if (ch == '-' && hasExponent) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = false;
                ++current;
                continue;
            }
            if (ch == '+' && hasExponent) {
                if (current == start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '+' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isExponentPositive = true;
                ++current;
                continue;
            }
            if (ch == '-') {
                if (current != start) {
                    AbstractJsonLexer.fail$default(this, "Unexpected symbol '-' in numeric literal", 0, null, 6, null);
                    throw new KotlinNothingValueException();
                }
                isNegative = true;
                ++current;
                continue;
            }
            byte token = AbstractJsonLexerKt.charToTokenClass(ch);
            if (token != 0) break;
            ++current;
            int digit = ch - 48;
            if (!(0 <= digit ? digit < 10 : false)) {
                AbstractJsonLexer.fail$default(this, "Unexpected symbol '" + ch + "' in numeric literal", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (hasExponent) {
                exponentAccumulator = exponentAccumulator * (long)10 + (long)digit;
                continue;
            }
            if ((accumulator = accumulator * (long)10 - (long)digit) <= 0L) continue;
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        boolean bl2 = hasChars = current != start;
        if (start == current || isNegative && start == current - 1) {
            AbstractJsonLexer.fail$default(this, "Expected numeric literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (hasQuotation) {
            if (!hasChars) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(current) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++current;
        }
        this.currentPosition = current;
        if (hasExponent) {
            double doubleAccumulator = (double)accumulator * AbstractJsonLexer.consumeNumericLiteral$calculateExponent(exponentAccumulator, isExponentPositive);
            if (doubleAccumulator > 9.223372036854776E18 || doubleAccumulator < -9.223372036854776E18) {
                AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (!(Math.floor(doubleAccumulator) == doubleAccumulator)) {
                AbstractJsonLexer.fail$default(this, "Can't convert " + doubleAccumulator + " to Long", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            accumulator = (long)doubleAccumulator;
        }
        if (isNegative) {
            l = accumulator;
        } else if (accumulator != Long.MIN_VALUE) {
            l = -accumulator;
        } else {
            AbstractJsonLexer.fail$default(this, "Numeric value overflow", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return l;
    }

    public final boolean consumeBooleanLenient() {
        boolean bl;
        int current = this.skipWhitespaces();
        if (current == this.getSource().length()) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        if (this.getSource().charAt(current) == '\"') {
            ++current;
            bl = true;
        } else {
            bl = false;
        }
        boolean hasQuotation = bl;
        boolean result2 = this.consumeBoolean(current);
        if (hasQuotation) {
            if (this.currentPosition == this.getSource().length()) {
                AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            if (this.getSource().charAt(this.currentPosition) != '\"') {
                AbstractJsonLexer.fail$default(this, "Expected closing quotation mark", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            ++this.currentPosition;
        }
        return result2;
    }

    private final boolean consumeBoolean(int start) {
        boolean bl;
        int current = this.prefetchOrEof(start);
        if (current >= this.getSource().length() || current == -1) {
            AbstractJsonLexer.fail$default(this, "EOF", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        switch (this.getSource().charAt(current++) | 0x20) {
            case 116: {
                this.consumeBooleanLiteral("rue", current);
                bl = true;
                break;
            }
            case 102: {
                this.consumeBooleanLiteral("alse", current);
                bl = false;
                break;
            }
            default: {
                AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
        }
        return bl;
    }

    private final void consumeBooleanLiteral(String literalSuffix, int current) {
        if (this.getSource().length() - current < literalSuffix.length()) {
            AbstractJsonLexer.fail$default(this, "Unexpected end of boolean literal", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        int n = ((CharSequence)literalSuffix).length();
        for (int i = 0; i < n; ++i) {
            char actual;
            char expected = literalSuffix.charAt(i);
            if (expected == ((actual = this.getSource().charAt(current + i)) | 0x20)) continue;
            AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        this.currentPosition = current + literalSuffix.length();
    }

    private static final double consumeNumericLiteral$calculateExponent(long exponentAccumulator, boolean isExponentPositive) {
        double d;
        boolean bl = isExponentPositive;
        if (!bl) {
            d = Math.pow(10.0, -((double)exponentAccumulator));
        } else if (bl) {
            d = Math.pow(10.0, exponentAccumulator);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return d;
    }
}

