/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Iterator;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractCollectionSerializer;

public abstract class MapLikeSerializer<Key, Value, Collection, Builder extends Map<Key, Value>>
extends AbstractCollectionSerializer<Map.Entry<? extends Key, ? extends Value>, Collection, Builder> {
    private final KSerializer<Key> keySerializer;
    private final KSerializer<Value> valueSerializer;

    private MapLikeSerializer(KSerializer<Key> keySerializer, KSerializer<Value> valueSerializer) {
        super(null);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public final KSerializer<Key> getKeySerializer() {
        return this.keySerializer;
    }

    public final KSerializer<Value> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public abstract SerialDescriptor getDescriptor();

    @Override
    protected final void readAll(CompositeDecoder decoder, Builder builder, int startIndex, int size) {
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        Intrinsics.checkNotNullParameter(builder, "builder");
        if (!(size >= 0)) {
            boolean $i$a$-require-MapLikeSerializer$readAll$22 = false;
            String $i$a$-require-MapLikeSerializer$readAll$22 = "Size must be known in advance when using READ_ALL";
            throw new IllegalArgumentException($i$a$-require-MapLikeSerializer$readAll$22.toString());
        }
        IntProgression intProgression = RangesKt.step(RangesKt.until(0, size * 2), 2);
        int index = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && index <= n || n2 < 0 && n <= index) {
            while (true) {
                this.readElement(decoder, startIndex + index, builder, false);
                if (index == n) break;
                index += n2;
            }
        }
    }

    @Override
    protected final void readElement(CompositeDecoder decoder, int index, Builder builder, boolean checkIndex) {
        int n;
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Object key = CompositeDecoder.DefaultImpls.decodeSerializableElement$default(decoder, this.getDescriptor(), index, this.keySerializer, null, 8, null);
        if (checkIndex) {
            int n2;
            int it = n2 = decoder.decodeElementIndex(this.getDescriptor());
            boolean bl = false;
            if (!(it == index + 1)) {
                boolean bl2 = false;
                String string = "Value must follow key in a map, index for key: " + index + ", returned index for value: " + it;
                throw new IllegalArgumentException(string.toString());
            }
            n = n2;
        } else {
            n = index + 1;
        }
        int vIndex = n;
        Object value = builder.containsKey(key) && !(this.valueSerializer.getDescriptor().getKind() instanceof PrimitiveKind) ? decoder.decodeSerializableElement(this.getDescriptor(), vIndex, (DeserializationStrategy)this.valueSerializer, MapsKt.getValue(builder, key)) : CompositeDecoder.DefaultImpls.decodeSerializableElement$default(decoder, this.getDescriptor(), vIndex, this.valueSerializer, null, 8, null);
        builder.put((Object)key, (Object)value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serialize(Encoder encoder, Collection value) {
        void $this$encodeCollection$iv;
        CompositeEncoder composite$iv;
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        int size = this.collectionSize(value);
        Encoder encoder2 = encoder;
        SerialDescriptor descriptor$iv = this.getDescriptor();
        boolean $i$f$encodeCollection = false;
        CompositeEncoder $this$serialize_u24lambda_u244 = composite$iv = $this$encodeCollection$iv.beginCollection(descriptor$iv, size);
        boolean bl = false;
        Iterator iterator2 = this.collectionIterator(value);
        int index = 0;
        Iterator $this$forEach$iv = iterator2;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            int n = index;
            index = n + 1;
            $this$serialize_u24lambda_u244.encodeSerializableElement(this.getDescriptor(), n, (SerializationStrategy)this.getKeySerializer(), k);
            n = index;
            index = n + 1;
            $this$serialize_u24lambda_u244.encodeSerializableElement(this.getDescriptor(), n, (SerializationStrategy)this.getValueSerializer(), v);
        }
        composite$iv.endStructure(descriptor$iv);
    }

    public /* synthetic */ MapLikeSerializer(KSerializer keySerializer, KSerializer valueSerializer, DefaultConstructorMarker $constructor_marker) {
        this(keySerializer, valueSerializer);
    }
}

