/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines;

import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlinx.coroutines.CompletedExceptionally;
import kotlinx.coroutines.CompletionStateKt;
import kotlinx.coroutines.CoroutineContextKt;
import kotlinx.coroutines.CoroutineExceptionHandlerKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DebugStringsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobSupport;
import kotlinx.coroutines.JobSupportKt;

public abstract class AbstractCoroutine<T>
extends JobSupport
implements Continuation<T>,
CoroutineScope {
    private final CoroutineContext context;

    public AbstractCoroutine(CoroutineContext parentContext, boolean initParentJob, boolean active) {
        super(active);
        if (initParentJob) {
            this.initParentJob((Job)parentContext.get(Job.Key));
        }
        this.context = parentContext.plus(this);
    }

    @Override
    public final CoroutineContext getContext() {
        return this.context;
    }

    @Override
    public CoroutineContext getCoroutineContext() {
        return this.context;
    }

    @Override
    public boolean isActive() {
        return super.isActive();
    }

    protected void onCompleted(T value) {
    }

    protected void onCancelled(Throwable cause, boolean handled) {
    }

    @Override
    protected String cancellationExceptionMessage() {
        return DebugStringsKt.getClassSimpleName(this) + " was cancelled";
    }

    @Override
    protected final void onCompletionInternal(Object state) {
        if (state instanceof CompletedExceptionally) {
            this.onCancelled(((CompletedExceptionally)state).cause, ((CompletedExceptionally)state).getHandled());
        } else {
            this.onCompleted(state);
        }
    }

    @Override
    public final void resumeWith(Object result2) {
        Object state = this.makeCompletingOnce$kotlinx_coroutines_core(CompletionStateKt.toState$default(result2, null, 1, null));
        if (state == JobSupportKt.COMPLETING_WAITING_CHILDREN) {
            return;
        }
        this.afterResume(state);
    }

    protected void afterResume(Object state) {
        this.afterCompletion(state);
    }

    @Override
    public final void handleOnCompletionException$kotlinx_coroutines_core(Throwable exception) {
        CoroutineExceptionHandlerKt.handleCoroutineException(this.context, exception);
    }

    @Override
    public String nameString$kotlinx_coroutines_core() {
        String string = CoroutineContextKt.getCoroutineName(this.context);
        if (string == null) {
            return super.nameString$kotlinx_coroutines_core();
        }
        String coroutineName = string;
        return '\"' + coroutineName + "\":" + super.nameString$kotlinx_coroutines_core();
    }

    public final <R> void start(CoroutineStart start, R receiver, Function2<? super R, ? super Continuation<? super T>, ? extends Object> block) {
        start.invoke(block, receiver, this);
    }
}

