/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.http;

import com.apollographql.apollo.api.http.HttpHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

public final class HttpResponse {
    private final int statusCode;
    private final List<HttpHeader> headers;
    private final BufferedSource bodySource;
    private final ByteString bodyString;

    private HttpResponse(int statusCode, List<HttpHeader> headers, BufferedSource bodySource, ByteString bodyString) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.bodySource = bodySource;
        this.bodyString = bodyString;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public final BufferedSource getBody() {
        BufferedSource bufferedSource = this.bodySource;
        if (bufferedSource == null) {
            Buffer buffer;
            ByteString byteString = this.bodyString;
            if (byteString != null) {
                ByteString it = byteString;
                boolean bl = false;
                buffer = new Buffer().write(it);
            } else {
                buffer = null;
            }
            bufferedSource = buffer;
        }
        return bufferedSource;
    }

    public /* synthetic */ HttpResponse(int statusCode, List headers, BufferedSource bodySource, ByteString bodyString, DefaultConstructorMarker $constructor_marker) {
        this(statusCode, headers, bodySource, bodyString);
    }

    public static final class Builder {
        private final int statusCode;
        private BufferedSource bodySource;
        private ByteString bodyString;
        private final List<HttpHeader> headers;

        public Builder(int statusCode) {
            this.statusCode = statusCode;
            this.headers = new ArrayList();
        }

        private final boolean getHasBody() {
            return this.bodySource != null || this.bodyString != null;
        }

        public final Builder body(BufferedSource bodySource) {
            Builder builder;
            Intrinsics.checkNotNullParameter(bodySource, "bodySource");
            Builder $this$body_u24lambda_u241 = builder = this;
            boolean bl = false;
            if (!(!$this$body_u24lambda_u241.getHasBody())) {
                boolean bl2 = false;
                String string = "body() can only be called once";
                throw new IllegalStateException(string.toString());
            }
            $this$body_u24lambda_u241.bodySource = bodySource;
            return builder;
        }

        public final Builder addHeaders(List<HttpHeader> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, "headers");
            Builder $this$addHeaders_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$addHeaders_u24lambda_u245.headers.addAll((Collection<HttpHeader>)headers);
            return builder;
        }

        public final HttpResponse build() {
            return new HttpResponse(this.statusCode, this.headers, this.bodySource, this.bodyString, null);
        }
    }
}

