/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.ws.MessageInflater;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

public final class WebSocketReader
implements Closeable {
    private final boolean isClient;
    private final BufferedSource source;
    private final FrameCallback frameCallback;
    private final boolean perMessageDeflate;
    private final boolean noContextTakeover;
    private boolean closed;
    private int opcode;
    private long frameLength;
    private boolean isFinalFrame;
    private boolean isControlFrame;
    private boolean readingCompressedMessage;
    private final Buffer controlFrameBuffer;
    private final Buffer messageFrameBuffer;
    private MessageInflater messageInflater;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    public WebSocketReader(boolean isClient, BufferedSource source2, FrameCallback frameCallback, boolean perMessageDeflate, boolean noContextTakeover) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(frameCallback, "frameCallback");
        this.isClient = isClient;
        this.source = source2;
        this.frameCallback = frameCallback;
        this.perMessageDeflate = perMessageDeflate;
        this.noContextTakeover = noContextTakeover;
        this.controlFrameBuffer = new Buffer();
        this.messageFrameBuffer = new Buffer();
        this.maskKey = this.isClient ? null : new byte[4];
        this.maskCursor = this.isClient ? null : new Buffer.UnsafeCursor();
    }

    public final void processNextFrame() throws IOException {
        this.readHeader();
        if (this.isControlFrame) {
            this.readControlFrame();
        } else {
            this.readMessageFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readHeader() throws IOException, ProtocolException {
        boolean isMasked;
        boolean reservedFlag3;
        boolean reservedFlag2;
        if (this.closed) {
            throw new IOException("closed");
        }
        int b0 = 0;
        long timeoutBefore = this.source.timeout().timeoutNanos();
        this.source.timeout().clearTimeout();
        try {
            b0 = Util.and(this.source.readByte(), 255);
        }
        finally {
            this.source.timeout().timeout(timeoutBefore, TimeUnit.NANOSECONDS);
        }
        this.opcode = b0 & 0xF;
        this.isFinalFrame = (b0 & 0x80) != 0;
        boolean bl = this.isControlFrame = (b0 & 8) != 0;
        if (this.isControlFrame && !this.isFinalFrame) {
            throw new ProtocolException("Control frames must be final.");
        }
        boolean reservedFlag1 = (b0 & 0x40) != 0;
        switch (this.opcode) {
            case 1: 
            case 2: {
                boolean bl2;
                if (reservedFlag1) {
                    if (!this.perMessageDeflate) {
                        throw new ProtocolException("Unexpected rsv1 flag");
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                this.readingCompressedMessage = bl2;
                break;
            }
            default: {
                if (!reservedFlag1) break;
                throw new ProtocolException("Unexpected rsv1 flag");
            }
        }
        boolean bl3 = reservedFlag2 = (b0 & 0x20) != 0;
        if (reservedFlag2) {
            throw new ProtocolException("Unexpected rsv2 flag");
        }
        boolean bl4 = reservedFlag3 = (b0 & 0x10) != 0;
        if (reservedFlag3) {
            throw new ProtocolException("Unexpected rsv3 flag");
        }
        int b1 = Util.and(this.source.readByte(), 255);
        boolean bl5 = isMasked = (b1 & 0x80) != 0;
        if (isMasked == this.isClient) {
            throw new ProtocolException(this.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.");
        }
        this.frameLength = b1 & 0x7F;
        if (this.frameLength == 126L) {
            this.frameLength = Util.and(this.source.readShort(), 65535);
        } else if (this.frameLength == 127L) {
            this.frameLength = this.source.readLong();
            if (this.frameLength < 0L) {
                throw new ProtocolException("Frame length 0x" + Util.toHexString(this.frameLength) + " > 0x7FFFFFFFFFFFFFFF");
            }
        }
        if (this.isControlFrame && this.frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (isMasked) {
            Intrinsics.checkNotNull(this.maskKey);
            this.source.readFully(this.maskKey);
        }
    }

    private final void readControlFrame() throws IOException {
        if (this.frameLength > 0L) {
            this.source.readFully(this.controlFrameBuffer, this.frameLength);
            if (!this.isClient) {
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull(unsafeCursor);
                this.controlFrameBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(0L);
                Intrinsics.checkNotNull(this.maskKey);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        switch (this.opcode) {
            case 9: {
                this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                break;
            }
            case 10: {
                this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                break;
            }
            case 8: {
                int code = 1005;
                String reason = "";
                long bufferSize = this.controlFrameBuffer.size();
                if (bufferSize == 1L) {
                    throw new ProtocolException("Malformed close payload length of 1.");
                }
                if (bufferSize != 0L) {
                    code = this.controlFrameBuffer.readShort();
                    reason = this.controlFrameBuffer.readUtf8();
                    String codeExceptionMessage = WebSocketProtocol.INSTANCE.closeCodeExceptionMessage(code);
                    if (codeExceptionMessage != null) {
                        throw new ProtocolException(codeExceptionMessage);
                    }
                }
                this.frameCallback.onReadClose(code, reason);
                this.closed = true;
                break;
            }
            default: {
                throw new ProtocolException(Intrinsics.stringPlus("Unknown control opcode: ", Util.toHexString(this.opcode)));
            }
        }
    }

    private final void readMessageFrame() throws IOException {
        int opcode = this.opcode;
        if (opcode != 1 && opcode != 2) {
            throw new ProtocolException(Intrinsics.stringPlus("Unknown opcode: ", Util.toHexString(opcode)));
        }
        this.readMessage();
        if (this.readingCompressedMessage) {
            MessageInflater messageInflater;
            MessageInflater messageInflater2 = this.messageInflater;
            if (messageInflater2 == null) {
                MessageInflater messageInflater3;
                MessageInflater it = messageInflater3 = new MessageInflater(this.noContextTakeover);
                boolean bl = false;
                this.messageInflater = it;
                messageInflater = messageInflater3;
            } else {
                messageInflater = messageInflater2;
            }
            MessageInflater messageInflater4 = messageInflater;
            messageInflater4.inflate(this.messageFrameBuffer);
        }
        if (opcode == 1) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
        } else {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
        }
    }

    private final void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            this.readHeader();
            if (!this.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private final void readMessage() throws IOException {
        block4: {
            do {
                if (this.closed) {
                    throw new IOException("closed");
                }
                if (this.frameLength > 0L) {
                    this.source.readFully(this.messageFrameBuffer, this.frameLength);
                    if (!this.isClient) {
                        Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                        Intrinsics.checkNotNull(unsafeCursor);
                        this.messageFrameBuffer.readAndWriteUnsafe(unsafeCursor);
                        this.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                        Intrinsics.checkNotNull(this.maskKey);
                        WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                        this.maskCursor.close();
                    }
                }
                if (this.isFinalFrame) break block4;
                this.readUntilNonControlFrame();
            } while (this.opcode == 0);
            throw new ProtocolException(Intrinsics.stringPlus("Expected continuation opcode. Got: ", Util.toHexString(this.opcode)));
        }
    }

    @Override
    public void close() throws IOException {
        MessageInflater messageInflater = this.messageInflater;
        if (messageInflater != null) {
            messageInflater.close();
        }
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

