/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonElementMarker;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonTreeReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;

public class StreamingJsonDecoder
extends AbstractDecoder
implements JsonDecoder {
    private final Json json;
    private final WriteMode mode;
    public final AbstractJsonLexer lexer;
    private final SerializersModule serializersModule;
    private int currentIndex;
    private DiscriminatorHolder discriminatorHolder;
    private final JsonConfiguration configuration;
    private final JsonElementMarker elementMarker;

    public StreamingJsonDecoder(Json json, WriteMode mode, AbstractJsonLexer lexer, SerialDescriptor descriptor, DiscriminatorHolder discriminatorHolder) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(lexer, "lexer");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        this.json = json;
        this.mode = mode;
        this.lexer = lexer;
        this.serializersModule = this.json.getSerializersModule();
        this.currentIndex = -1;
        this.discriminatorHolder = discriminatorHolder;
        this.configuration = this.json.getConfiguration();
        this.elementMarker = this.configuration.getExplicitNulls() ? null : new JsonElementMarker(descriptor);
    }

    @Override
    public final Json getJson() {
        return this.json;
    }

    private final boolean trySkip(DiscriminatorHolder $this$trySkip, String unknownKey) {
        if ($this$trySkip == null) {
            return false;
        }
        if (Intrinsics.areEqual($this$trySkip.discriminatorToSkip, unknownKey)) {
            $this$trySkip.discriminatorToSkip = null;
            return true;
        }
        return false;
    }

    @Override
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public JsonElement decodeJsonElement() {
        return new JsonTreeReader(this.json.getConfiguration(), this.lexer).read();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T decodeSerializableValue(DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        try {
            DeserializationStrategy deserializationStrategy;
            if (!(deserializer instanceof AbstractPolymorphicSerializer) || this.json.getConfiguration().getUseArrayPolymorphism()) {
                return deserializer.deserialize(this);
            }
            String discriminator = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializer).getDescriptor(), this.json);
            String string = this.lexer.peekLeadingMatchingValue(discriminator, this.configuration.isLenient());
            if (string == null) {
                T t;
                void $this$decodeSerializableValuePolymorphic$iv;
                JsonDecoder jsonDecoder = this;
                DeserializationStrategy<T> deserializer$iv = deserializer;
                boolean $i$f$decodeSerializableValuePolymorphic = false;
                if (!(deserializer$iv instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
                    t = deserializer$iv.deserialize((Decoder)$this$decodeSerializableValuePolymorphic$iv);
                } else {
                    DeserializationStrategy deserializationStrategy2;
                    void value$iv$iv;
                    String discriminator$iv = PolymorphicKt.classDiscriminator(((AbstractPolymorphicSerializer)deserializer$iv).getDescriptor(), $this$decodeSerializableValuePolymorphic$iv.getJson());
                    JsonElement jsonElement = $this$decodeSerializableValuePolymorphic$iv.decodeJsonElement();
                    String serialName$iv$iv = ((AbstractPolymorphicSerializer)deserializer$iv).getDescriptor().getSerialName();
                    boolean $i$f$cast = false;
                    if (!(value$iv$iv instanceof JsonObject)) {
                        StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                        int n = -1;
                        boolean bl = false;
                        String string2 = this.lexer.path.getPath();
                        throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string2).toString(), value$iv$iv.toString());
                    }
                    JsonObject jsonTree$iv = (JsonObject)value$iv$iv;
                    JsonElement jsonElement2 = (JsonElement)jsonTree$iv.get((Object)discriminator$iv);
                    String type$iv = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
                    try {
                        deserializationStrategy2 = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)deserializer$iv, (CompositeDecoder)$this$decodeSerializableValuePolymorphic$iv, type$iv);
                    }
                    catch (SerializationException it$iv) {
                        String string3 = it$iv.getMessage();
                        Intrinsics.checkNotNull(string3);
                        throw JsonExceptionsKt.JsonDecodingException(-1, string3, jsonTree$iv.toString());
                    }
                    DeserializationStrategy deserializationStrategy3 = deserializationStrategy2;
                    Intrinsics.checkNotNull(deserializationStrategy3, "null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.decodeSerializableValuePolymorphic>");
                    DeserializationStrategy actualSerializer$iv = deserializationStrategy3;
                    t = TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic$iv.getJson(), discriminator$iv, jsonTree$iv, actualSerializer$iv);
                }
                return t;
            }
            String type = string;
            try {
                deserializationStrategy = PolymorphicSerializerKt.findPolymorphicSerializer((AbstractPolymorphicSerializer)deserializer, this, type);
            }
            catch (SerializationException it) {
                String string4 = it.getMessage();
                Intrinsics.checkNotNull(string4);
                String message = StringsKt.removeSuffix(StringsKt.substringBefore$default(string4, '\n', null, 2, null), ".");
                String string5 = it.getMessage();
                Intrinsics.checkNotNull(string5);
                String hint = StringsKt.substringAfter(string5, '\n', "");
                AbstractJsonLexer.fail$default(this.lexer, message, 0, hint, 2, null);
                throw new KotlinNothingValueException();
            }
            DeserializationStrategy deserializationStrategy4 = deserializationStrategy;
            Intrinsics.checkNotNull(deserializationStrategy4, "null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of kotlinx.serialization.json.internal.StreamingJsonDecoder.decodeSerializableValue>");
            DeserializationStrategy actualSerializer = deserializationStrategy4;
            this.discriminatorHolder = new DiscriminatorHolder(discriminator);
            return actualSerializer.deserialize(this);
        }
        catch (MissingFieldException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull(string);
            if (StringsKt.contains$default((CharSequence)string, "at path", false, 2, null)) {
                throw e;
            }
            throw new MissingFieldException(e.getMissingFields(), e.getMessage() + " at path: " + this.lexer.path.getPath(), e);
        }
    }

    @Override
    public CompositeDecoder beginStructure(SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.json, descriptor);
        this.lexer.path.pushDescriptor(descriptor);
        this.lexer.consumeNextToken(newMode.begin);
        this.checkLeadingComma();
        switch (WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor, this.discriminatorHolder);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode && this.json.getConfiguration().getExplicitNulls() ? this : new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor, this.discriminatorHolder);
            }
        }
        return compositeDecoder;
    }

    @Override
    public void endStructure(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        if (this.json.getConfiguration().getIgnoreUnknownKeys() && descriptor.getElementsCount() == 0) {
            this.skipLeftoverElements(descriptor);
        }
        if (this.lexer.tryConsumeComma() && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma(this.lexer, "");
            throw new KotlinNothingValueException();
        }
        this.lexer.consumeNextToken(this.mode.end);
        this.lexer.path.popDescriptor();
    }

    private final void skipLeftoverElements(SerialDescriptor descriptor) {
        while (this.decodeElementIndex(descriptor) != -1) {
        }
    }

    @Override
    public boolean decodeNotNullMark() {
        JsonElementMarker jsonElementMarker = this.elementMarker;
        return !(jsonElementMarker != null ? jsonElementMarker.isUnmarkedNull$kotlinx_serialization_json() : false) && !AbstractJsonLexer.tryConsumeNull$default(this.lexer, false, 1, null);
    }

    @Override
    public Void decodeNull() {
        return null;
    }

    private final void checkLeadingComma() {
        if (this.lexer.peekNextToken() == 4) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public <T> T decodeSerializableElement(SerialDescriptor descriptor, int index, DeserializationStrategy<? extends T> deserializer, T previousValue) {
        boolean isMapKey;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        boolean bl = isMapKey = this.mode == WriteMode.MAP && (index & 1) == 0;
        if (isMapKey) {
            this.lexer.path.resetCurrentMapKey();
        }
        T value = super.decodeSerializableElement(descriptor, index, deserializer, previousValue);
        if (isMapKey) {
            this.lexer.path.updateCurrentMapKey(value);
        }
        return value;
    }

    @Override
    public int decodeElementIndex(SerialDescriptor descriptor) {
        int index;
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 4: {
                int n = this.decodeObjectIndex(descriptor);
                break;
            }
            case 2: {
                int n = this.decodeMapIndex();
                break;
            }
            default: {
                int n = index = this.decodeListIndex();
            }
        }
        if (this.mode != WriteMode.MAP) {
            this.lexer.path.updateDescriptorIndex(index);
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeMapIndex() {
        int n;
        boolean decodingKey;
        boolean hasComma = false;
        boolean bl = decodingKey = this.currentIndex % 2 != 0;
        if (decodingKey) {
            if (this.currentIndex != -1) {
                hasComma = this.lexer.tryConsumeComma();
            }
        } else {
            this.lexer.consumeNextToken(':');
        }
        if (this.lexer.canConsumeValue()) {
            if (decodingKey) {
                if (this.currentIndex == -1) {
                    void $this$iv;
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    boolean condition$iv = !hasComma;
                    int position$iv = $this$iv.currentPosition;
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!condition$iv) {
                        void var8_11 = $this$iv;
                        boolean bl2 = false;
                        AbstractJsonLexer.fail$default((AbstractJsonLexer)var8_11, "Unexpected leading comma", position$iv, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                } else {
                    AbstractJsonLexer $this$iv = this.lexer;
                    int position$iv = $this$iv.currentPosition;
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!hasComma) {
                        AbstractJsonLexer abstractJsonLexer = $this$iv;
                        boolean bl3 = false;
                        AbstractJsonLexer.fail$default(abstractJsonLexer, "Expected comma after the key-value pair", position$iv, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                }
            }
            n = ++this.currentIndex;
        } else {
            if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
                JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor, int index) {
        boolean bl;
        boolean it;
        Json $this$tryCoerceValue$iv = this.json;
        boolean $i$f$tryCoerceValue = false;
        boolean isOptional$iv = descriptor.isElementOptional(index);
        SerialDescriptor elementDescriptor$iv = descriptor.getElementDescriptor(index);
        if (isOptional$iv && !elementDescriptor$iv.isNullable()) {
            it = true;
            bl = false;
            if (this.lexer.tryConsumeNull(it)) {
                return true;
            }
        }
        if (!Intrinsics.areEqual(elementDescriptor$iv.getKind(), SerialKind.ENUM.INSTANCE)) return false;
        if (elementDescriptor$iv.isNullable()) {
            it = false;
            bl = false;
            if (this.lexer.tryConsumeNull(it)) {
                return false;
            }
        }
        boolean bl2 = false;
        String string = this.lexer.peekString(this.configuration.isLenient());
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex(elementDescriptor$iv, $this$tryCoerceValue$iv, enumValue$iv);
        boolean coerceToNull$iv = !$this$tryCoerceValue$iv.getConfiguration().getExplicitNulls() && elementDescriptor$iv.isNullable();
        if (enumIndex$iv != -3) return false;
        if (!isOptional$iv) {
            if (!coerceToNull$iv) return false;
        }
        boolean bl3 = false;
        this.lexer.consumeString();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int decodeObjectIndex(SerialDescriptor descriptor) {
        boolean hasComma = this.lexer.tryConsumeComma();
        while (this.lexer.canConsumeValue()) {
            boolean isUnknown;
            boolean bl;
            String key;
            block5: {
                hasComma = false;
                key = this.decodeStringKey();
                this.lexer.consumeNextToken(':');
                int index = JsonNamesMapKt.getJsonNameIndex(descriptor, this.json, key);
                if (index != -3) {
                    if (this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor, index)) {
                        hasComma = this.lexer.tryConsumeComma();
                        bl = false;
                        break block5;
                    } else {
                        JsonElementMarker jsonElementMarker = this.elementMarker;
                        if (jsonElementMarker == null) return index;
                        jsonElementMarker.mark$kotlinx_serialization_json(index);
                        return index;
                    }
                }
                bl = true;
            }
            if (!(isUnknown = bl)) continue;
            hasComma = this.handleUnknown(key);
        }
        if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
            JsonExceptionsKt.invalidTrailingComma$default(this.lexer, null, 1, null);
            throw new KotlinNothingValueException();
        }
        JsonElementMarker jsonElementMarker = this.elementMarker;
        if (jsonElementMarker == null) return -1;
        int n = jsonElementMarker.nextUnmarkedIndex$kotlinx_serialization_json();
        return n;
    }

    private final boolean handleUnknown(String key) {
        if (this.configuration.getIgnoreUnknownKeys() || this.trySkip(this.discriminatorHolder, key)) {
            this.lexer.skipElement(this.configuration.isLenient());
        } else {
            this.lexer.failOnUnknownKey(key);
        }
        return this.lexer.tryConsumeComma();
    }

    private final int decodeListIndex() {
        int n;
        boolean hasComma = this.lexer.tryConsumeComma();
        if (this.lexer.canConsumeValue()) {
            if (this.currentIndex != -1 && !hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected end of the array or comma", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            n = ++this.currentIndex;
        } else {
            if (hasComma && !this.json.getConfiguration().getAllowTrailingComma()) {
                JsonExceptionsKt.invalidTrailingComma(this.lexer, "array");
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    @Override
    public boolean decodeBoolean() {
        return this.lexer.consumeBooleanLenient();
    }

    @Override
    public byte decodeByte() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((byte)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse byte for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (byte)value;
    }

    @Override
    public short decodeShort() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((short)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse short for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (short)value;
    }

    @Override
    public int decodeInt() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((int)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse int for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (int)value;
    }

    @Override
    public long decodeLong() {
        return this.lexer.consumeNumericLiteral();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float decodeFloat() {
        float f;
        float f2;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "float";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeFloat_u24lambda_u246 = input$iv;
            boolean bl = false;
            f2 = Float.parseFloat($this$decodeFloat_u24lambda_u246);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        float result2 = f2;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Float.isInfinite(f = result2) && !Float.isNaN(f)) {
            return result2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, Float.valueOf(result2));
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double decodeDouble() {
        double d;
        double d2;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "double";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeDouble_u24lambda_u247 = input$iv;
            boolean bl = false;
            d2 = Double.parseDouble($this$decodeDouble_u24lambda_u247);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        double result2 = d2;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Double.isInfinite(d = result2) && !Double.isNaN(d)) {
            return result2;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, result2);
        throw new KotlinNothingValueException();
    }

    @Override
    public char decodeChar() {
        String string = this.lexer.consumeStringLenient();
        if (string.length() != 1) {
            AbstractJsonLexer.fail$default(this.lexer, "Expected single char, but got '" + string + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return string.charAt(0);
    }

    private final String decodeStringKey() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeKeyString();
    }

    @Override
    public String decodeString() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeString();
    }

    @Override
    public Decoder decodeInline(SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(descriptor) ? (Decoder)new JsonDecoderForUnsignedTypes(this.lexer, this.json) : super.decodeInline(descriptor);
    }

    public static final class DiscriminatorHolder {
        public String discriminatorToSkip;

        public DiscriminatorHolder(String discriminatorToSkip) {
            this.discriminatorToSkip = discriminatorToSkip;
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.OBJ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

