/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.internal.DescriptorSchemaCache;
import kotlinx.serialization.json.internal.JsonStreamsKt;
import kotlinx.serialization.json.internal.JsonToStringWriter;
import kotlinx.serialization.json.internal.StreamingJsonDecoder;
import kotlinx.serialization.json.internal.StringJsonLexer;
import kotlinx.serialization.json.internal.StringJsonLexerKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuildersKt;

public abstract class Json
implements StringFormat {
    public static final Default Default = new Default(null);
    private final JsonConfiguration configuration;
    private final SerializersModule serializersModule;
    private final DescriptorSchemaCache _schemaCache;

    private Json(JsonConfiguration configuration, SerializersModule serializersModule) {
        this.configuration = configuration;
        this.serializersModule = serializersModule;
        this._schemaCache = new DescriptorSchemaCache();
    }

    public final JsonConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public final DescriptorSchemaCache get_schemaCache$kotlinx_serialization_json() {
        return this._schemaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> String encodeToString(SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        JsonToStringWriter result2 = new JsonToStringWriter();
        try {
            JsonStreamsKt.encodeByWriter(this, result2, serializer, value);
            String string = result2.toString();
            return string;
        }
        finally {
            result2.release();
        }
    }

    public final <T> T decodeFromString(DeserializationStrategy<? extends T> deserializer, String string) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        Intrinsics.checkNotNullParameter(string, "string");
        StringJsonLexer lexer = StringJsonLexerKt.StringJsonLexer(this, string);
        StreamingJsonDecoder input = new StreamingJsonDecoder(this, WriteMode.OBJ, lexer, deserializer.getDescriptor(), null);
        T result2 = input.decodeSerializableValue(deserializer);
        lexer.expectEof();
        return result2;
    }

    public /* synthetic */ Json(JsonConfiguration configuration, SerializersModule serializersModule, DefaultConstructorMarker $constructor_marker) {
        this(configuration, serializersModule);
    }

    public static final class Default
    extends Json {
        private Default() {
            super(new JsonConfiguration(false, false, false, false, false, false, null, false, false, null, false, false, null, false, false, false, null, 131071, null), SerializersModuleBuildersKt.EmptySerializersModule(), null);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

