/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.descriptors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.internal.CachedNames;
import kotlinx.serialization.internal.Platform_commonKt;
import kotlinx.serialization.internal.PluginGeneratedSerialDescriptorKt;

public final class SerialDescriptorImpl
implements SerialDescriptor,
CachedNames {
    private final String serialName;
    private final SerialKind kind;
    private final int elementsCount;
    private final List<Annotation> annotations;
    private final Set<String> serialNames;
    private final String[] elementNames;
    private final SerialDescriptor[] elementDescriptors;
    private final List<Annotation>[] elementAnnotations;
    private final boolean[] elementOptionality;
    private final Map<String, Integer> name2Index;
    private final SerialDescriptor[] typeParametersDescriptors;
    private final Lazy _hashCode$delegate;

    /*
     * WARNING - void declaration
     */
    public SerialDescriptorImpl(String serialName, SerialKind kind, int elementsCount, List<? extends SerialDescriptor> typeParameters, ClassSerialDescriptorBuilder builder) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(kind, "kind");
        Intrinsics.checkNotNullParameter(typeParameters, "typeParameters");
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.serialName = serialName;
        this.kind = kind;
        this.elementsCount = elementsCount;
        this.annotations = builder.getAnnotations();
        this.serialNames = CollectionsKt.toHashSet((Iterable)builder.getElementNames$kotlinx_serialization_core());
        Iterable<Object> $this$toTypedArray$iv = builder.getElementNames$kotlinx_serialization_core();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.elementNames = thisCollection$iv.toArray(new String[0]);
        this.elementDescriptors = Platform_commonKt.compactArray(builder.getElementDescriptors$kotlinx_serialization_core());
        $this$toTypedArray$iv = builder.getElementAnnotations$kotlinx_serialization_core();
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        this.elementAnnotations = thisCollection$iv.toArray(new List[0]);
        this.elementOptionality = CollectionsKt.toBooleanArray((Collection<Boolean>)builder.getElementOptionality$kotlinx_serialization_core());
        $this$toTypedArray$iv = ArraysKt.withIndex(this.elementNames);
        SerialDescriptorImpl serialDescriptorImpl = this;
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedValue indexedValue = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getValue(), it.getIndex()));
        }
        serialDescriptorImpl.name2Index = MapsKt.toMap((List)destination$iv$iv);
        this.typeParametersDescriptors = Platform_commonKt.compactArray(typeParameters);
        this._hashCode$delegate = LazyKt.lazy(() -> SerialDescriptorImpl._hashCode_delegate$lambda$1(this));
    }

    @Override
    public String getSerialName() {
        return this.serialName;
    }

    @Override
    public SerialKind getKind() {
        return this.kind;
    }

    @Override
    public int getElementsCount() {
        return this.elementsCount;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Set<String> getSerialNames() {
        return this.serialNames;
    }

    private final int get_hashCode() {
        Lazy lazy = this._hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public String getElementName(int index) {
        String[] $this$getChecked$iv = this.elementNames;
        boolean $i$f$getChecked = false;
        return $this$getChecked$iv[index];
    }

    @Override
    public int getElementIndex(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Integer n = this.name2Index.get(name);
        return n != null ? n : -3;
    }

    @Override
    public List<Annotation> getElementAnnotations(int index) {
        List<Annotation>[] $this$getChecked$iv = this.elementAnnotations;
        boolean $i$f$getChecked = false;
        return $this$getChecked$iv[index];
    }

    @Override
    public SerialDescriptor getElementDescriptor(int index) {
        SerialDescriptor[] $this$getChecked$iv = this.elementDescriptors;
        boolean $i$f$getChecked = false;
        return $this$getChecked$iv[index];
    }

    @Override
    public boolean isElementOptional(int index) {
        boolean[] $this$getChecked$iv = this.elementOptionality;
        boolean $i$f$getChecked = false;
        return $this$getChecked$iv[index];
    }

    public boolean equals(Object other) {
        boolean bl;
        block13: {
            SerialDescriptor $this$equalsImpl$iv = this;
            boolean $i$f$equalsImpl = false;
            if ($this$equalsImpl$iv == other) {
                bl = true;
            } else if (!(other instanceof SerialDescriptorImpl)) {
                bl = false;
            } else if (!Intrinsics.areEqual($this$equalsImpl$iv.getSerialName(), ((SerialDescriptor)other).getSerialName())) {
                bl = false;
            } else {
                SerialDescriptorImpl otherDescriptor = (SerialDescriptorImpl)other;
                boolean bl2 = false;
                if (!Arrays.equals(this.typeParametersDescriptors, otherDescriptor.typeParametersDescriptors)) {
                    bl = false;
                } else if ($this$equalsImpl$iv.getElementsCount() != ((SerialDescriptor)other).getElementsCount()) {
                    bl = false;
                } else {
                    int n = $this$equalsImpl$iv.getElementsCount();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        if (!Intrinsics.areEqual($this$equalsImpl$iv.getElementDescriptor(index$iv).getSerialName(), ((SerialDescriptor)other).getElementDescriptor(index$iv).getSerialName())) {
                            bl = false;
                        } else {
                            if (Intrinsics.areEqual($this$equalsImpl$iv.getElementDescriptor(index$iv).getKind(), ((SerialDescriptor)other).getElementDescriptor(index$iv).getKind())) continue;
                            bl = false;
                        }
                        break block13;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.get_hashCode();
    }

    public String toString() {
        return CollectionsKt.joinToString$default(RangesKt.until(0, this.getElementsCount()), ", ", this.getSerialName() + '(', ")", 0, null, arg_0 -> SerialDescriptorImpl.toString$lambda$3(this, arg_0), 24, null);
    }

    @Override
    public boolean isNullable() {
        return SerialDescriptor.DefaultImpls.isNullable(this);
    }

    @Override
    public boolean isInline() {
        return SerialDescriptor.DefaultImpls.isInline(this);
    }

    private static final int _hashCode_delegate$lambda$1(SerialDescriptorImpl this$0) {
        return PluginGeneratedSerialDescriptorKt.hashCodeImpl(this$0, this$0.typeParametersDescriptors);
    }

    private static final CharSequence toString$lambda$3(SerialDescriptorImpl this$0, int it) {
        return this$0.getElementName(it) + ": " + this$0.getElementDescriptor(it).getSerialName();
    }
}

