/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.EmptyMap;
import kotlin.collections.MapsKt;
import kotlin.collections.MapsKt__MapsJVMKt;
import kotlin.jvm.internal.Intrinsics;

class MapsKt__MapsKt
extends MapsKt__MapsJVMKt {
    public static final <K, V> Map<K, V> emptyMap() {
        EmptyMap emptyMap = EmptyMap.INSTANCE;
        Intrinsics.checkNotNull(emptyMap, "null cannot be cast to non-null type kotlin.collections.Map<K of kotlin.collections.MapsKt__MapsKt.emptyMap, V of kotlin.collections.MapsKt__MapsKt.emptyMap>");
        return emptyMap;
    }

    public static final <K, V> Map<K, V> mapOf(Pair<? extends K, ? extends V> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, "pairs");
        return pairs.length > 0 ? MapsKt.toMap(pairs, (Map)new LinkedHashMap(MapsKt.mapCapacity(pairs.length))) : MapsKt.emptyMap();
    }

    public static final <K, V> Map<K, V> mutableMapOf(Pair<? extends K, ? extends V> ... pairs) {
        LinkedHashMap linkedHashMap;
        Intrinsics.checkNotNullParameter(pairs, "pairs");
        LinkedHashMap $this$mutableMapOf_u24lambda_u240 = linkedHashMap = new LinkedHashMap(MapsKt.mapCapacity(pairs.length));
        boolean bl = false;
        MapsKt.putAll((Map)$this$mutableMapOf_u24lambda_u240, pairs);
        return linkedHashMap;
    }

    public static final <K, V> V getValue(Map<K, ? extends V> $this$getValue, K key) {
        Intrinsics.checkNotNullParameter($this$getValue, "<this>");
        return MapsKt.getOrImplicitDefaultNullable($this$getValue, key);
    }

    public static final <K, V> void putAll(Map<? super K, ? super V> $this$putAll, Pair<? extends K, ? extends V>[] pairs) {
        Intrinsics.checkNotNullParameter($this$putAll, "<this>");
        Intrinsics.checkNotNullParameter(pairs, "pairs");
        for (Pair<K, V> pair : pairs) {
            K key = pair.component1();
            V value = pair.component2();
            $this$putAll.put(key, value);
        }
    }

    public static final <K, V> void putAll(Map<? super K, ? super V> $this$putAll, Iterable<? extends Pair<? extends K, ? extends V>> pairs) {
        Intrinsics.checkNotNullParameter($this$putAll, "<this>");
        Intrinsics.checkNotNullParameter(pairs, "pairs");
        for (Pair<K, V> pair : pairs) {
            K key = pair.component1();
            V value = pair.component2();
            $this$putAll.put(key, value);
        }
    }

    public static final <K, V> Map<K, V> toMap(Iterable<? extends Pair<? extends K, ? extends V>> $this$toMap) {
        Intrinsics.checkNotNullParameter($this$toMap, "<this>");
        if ($this$toMap instanceof Collection) {
            Map map2;
            switch (((Collection)$this$toMap).size()) {
                case 0: {
                    map2 = MapsKt.emptyMap();
                    break;
                }
                case 1: {
                    map2 = MapsKt.mapOf($this$toMap instanceof List ? (Pair)((List)$this$toMap).get(0) : $this$toMap.iterator().next());
                    break;
                }
                default: {
                    map2 = MapsKt.toMap($this$toMap, (Map)new LinkedHashMap(MapsKt.mapCapacity(((Collection)$this$toMap).size())));
                }
            }
            return map2;
        }
        return MapsKt.optimizeReadOnlyMap(MapsKt.toMap($this$toMap, (Map)new LinkedHashMap()));
    }

    public static final <K, V, M extends Map<? super K, ? super V>> M toMap(Iterable<? extends Pair<? extends K, ? extends V>> $this$toMap, M destination) {
        M m;
        Intrinsics.checkNotNullParameter($this$toMap, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        M $this$toMap_u24lambda_u249 = m = destination;
        boolean bl = false;
        MapsKt.putAll($this$toMap_u24lambda_u249, $this$toMap);
        return m;
    }

    public static final <K, V, M extends Map<? super K, ? super V>> M toMap(Pair<? extends K, ? extends V>[] $this$toMap, M destination) {
        M m;
        Intrinsics.checkNotNullParameter($this$toMap, "<this>");
        Intrinsics.checkNotNullParameter(destination, "destination");
        M $this$toMap_u24lambda_u2410 = m = destination;
        boolean bl = false;
        MapsKt.putAll($this$toMap_u24lambda_u2410, $this$toMap);
        return m;
    }

    public static final <K, V> Map<K, V> toMap(Map<? extends K, ? extends V> $this$toMap) {
        Map<Object, Object> map2;
        Intrinsics.checkNotNullParameter($this$toMap, "<this>");
        switch ($this$toMap.size()) {
            case 0: {
                map2 = MapsKt.emptyMap();
                break;
            }
            case 1: {
                map2 = MapsKt.toSingletonMap($this$toMap);
                break;
            }
            default: {
                map2 = MapsKt.toMutableMap($this$toMap);
            }
        }
        return map2;
    }

    public static final <K, V> Map<K, V> toMutableMap(Map<? extends K, ? extends V> $this$toMutableMap) {
        Intrinsics.checkNotNullParameter($this$toMutableMap, "<this>");
        return new LinkedHashMap<K, V>($this$toMutableMap);
    }

    public static final <K, V> Map<K, V> optimizeReadOnlyMap(Map<K, ? extends V> $this$optimizeReadOnlyMap) {
        Map<K, Object> map2;
        Intrinsics.checkNotNullParameter($this$optimizeReadOnlyMap, "<this>");
        switch ($this$optimizeReadOnlyMap.size()) {
            case 0: {
                map2 = MapsKt.emptyMap();
                break;
            }
            case 1: {
                map2 = MapsKt.toSingletonMap($this$optimizeReadOnlyMap);
                break;
            }
            default: {
                map2 = $this$optimizeReadOnlyMap;
            }
        }
        return map2;
    }
}

