/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okio.Sink;
import okio.Source;

public final class Http2ExchangeCodec
implements ExchangeCodec {
    public static final Companion Companion = new Companion(null);
    private final RealConnection connection;
    private final RealInterceptorChain chain;
    private final Http2Connection http2Connection;
    private volatile Http2Stream stream;
    private final Protocol protocol;
    private volatile boolean canceled;
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS;
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS;

    public Http2ExchangeCodec(OkHttpClient client, RealConnection connection, RealInterceptorChain chain, Http2Connection http2Connection) {
        Intrinsics.checkNotNullParameter(client, "client");
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(chain, "chain");
        Intrinsics.checkNotNullParameter(http2Connection, "http2Connection");
        this.connection = connection;
        this.chain = chain;
        this.http2Connection = http2Connection;
        this.protocol = client.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    @Override
    public RealConnection getConnection() {
        return this.connection;
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) {
        Intrinsics.checkNotNullParameter(request, "request");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request.body() != null;
        List<Header> requestHeaders = Companion.http2HeadersList(request);
        this.stream = this.http2Connection.newStream(requestHeaders, hasRequestBody);
        if (this.canceled) {
            Http2Stream http2Stream = this.stream;
            Intrinsics.checkNotNull(http2Stream);
            http2Stream.closeLater(ErrorCode.CANCEL);
            throw new IOException("Canceled");
        }
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        http2Stream.readTimeout().timeout(this.chain.getReadTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        Http2Stream http2Stream2 = this.stream;
        Intrinsics.checkNotNull(http2Stream2);
        http2Stream2.writeTimeout().timeout(this.chain.getWriteTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() {
        this.http2Connection.flush();
    }

    @Override
    public void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        http2Stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean expectContinue) {
        Http2Stream http2Stream = this.stream;
        if (http2Stream == null) {
            throw new IOException("stream wasn't created");
        }
        Http2Stream stream = http2Stream;
        Headers headers = stream.takeHeaders();
        Response.Builder responseBuilder = Companion.readHttp2HeadersList(headers, this.protocol);
        return expectContinue && responseBuilder.getCode$okhttp() == 100 ? (Response.Builder)null : responseBuilder;
    }

    @Override
    public long reportedContentLength(Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return !HttpHeaders.promisesBody(response) ? 0L : Util.headersContentLength(response);
    }

    @Override
    public Source openResponseBodySource(Response response) {
        Intrinsics.checkNotNullParameter(response, "response");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.getSource$okhttp();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        Http2Stream http2Stream = this.stream;
        if (http2Stream != null) {
            http2Stream.closeLater(ErrorCode.CANCEL);
        }
    }

    static {
        String[] stringArray = new String[]{"connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority"};
        HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableListOf(stringArray);
        stringArray = new String[]{"connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade"};
        HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableListOf(stringArray);
    }

    public static final class Companion {
        private Companion() {
        }

        public final List<Header> http2HeadersList(Request request) {
            Intrinsics.checkNotNullParameter(request, "request");
            Headers headers = request.headers();
            ArrayList<Header> result2 = new ArrayList<Header>(headers.size() + 4);
            result2.add(new Header(Header.TARGET_METHOD, request.method()));
            result2.add(new Header(Header.TARGET_PATH, RequestLine.INSTANCE.requestPath(request.url())));
            String host = request.header("Host");
            if (host != null) {
                result2.add(new Header(Header.TARGET_AUTHORITY, host));
            }
            result2.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
            int n = 0;
            int n2 = headers.size();
            while (n < n2) {
                String name;
                int i = n++;
                String string = headers.name(i);
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue(locale, "US");
                Intrinsics.checkNotNullExpressionValue(string.toLowerCase(locale), "this as java.lang.String).toLowerCase(locale)");
                if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name) && (!Intrinsics.areEqual(name, "te") || !Intrinsics.areEqual(headers.value(i), "trailers"))) continue;
                result2.add(new Header(name, headers.value(i)));
            }
            return result2;
        }

        public final Response.Builder readHttp2HeadersList(Headers headerBlock, Protocol protocol) {
            Intrinsics.checkNotNullParameter(headerBlock, "headerBlock");
            Intrinsics.checkNotNullParameter((Object)protocol, "protocol");
            StatusLine statusLine = null;
            Headers.Builder headersBuilder = new Headers.Builder();
            int n = 0;
            int n2 = headerBlock.size();
            while (n < n2) {
                int i = n++;
                String name = headerBlock.name(i);
                String value = headerBlock.value(i);
                if (Intrinsics.areEqual(name, ":status")) {
                    statusLine = StatusLine.Companion.parse(Intrinsics.stringPlus("HTTP/1.1 ", value));
                    continue;
                }
                if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
                headersBuilder.addLenient$okhttp(name, value);
            }
            if (statusLine == null) {
                throw new ProtocolException("Expected ':status' header not present");
            }
            return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

