/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.lang.ref.Reference;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.platform.Platform;

public final class RealConnectionPool {
    public static final Companion Companion = new Companion(null);
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    private final ConcurrentLinkedQueue<RealConnection> connections;

    public RealConnectionPool(TaskRunner taskRunner, int maxIdleConnections, long keepAliveDuration, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter((Object)timeUnit, "timeUnit");
        this.maxIdleConnections = maxIdleConnections;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.cleanupQueue = taskRunner.newQueue();
        String string = Intrinsics.stringPlus(Util.okHttpName, " ConnectionPool");
        this.cleanupTask = new Task(this, string){
            final /* synthetic */ RealConnectionPool this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false, 2, null);
            }

            public long runOnce() {
                return this.this$0.cleanup(System.nanoTime());
            }
        };
        this.connections = new ConcurrentLinkedQueue();
        if (!(keepAliveDuration > 0L)) {
            boolean bl = false;
            String string2 = Intrinsics.stringPlus("keepAliveDuration <= 0: ", keepAliveDuration);
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean callAcquirePooledConnection(Address address, RealCall call, List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(call, "call");
        for (RealConnection connection : this.connections) {
            Intrinsics.checkNotNullExpressionValue(connection, "connection");
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                block5: {
                    boolean bl = false;
                    if (requireMultiplexed && !connection.isMultiplexed$okhttp() || !connection.isEligible$okhttp(address, routes)) break block5;
                    call.acquireConnectionNoEvents(connection);
                    boolean bl2 = true;
                    return bl2;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return false;
    }

    public final void put(RealConnection connection) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        this.connections.add(connection);
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    public final boolean connectionBecameIdle(RealConnection connection) {
        boolean bl;
        Intrinsics.checkNotNullParameter(connection, "connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            connection.setNoNewExchanges(true);
            this.connections.remove(connection);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            bl = true;
        } else {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long cleanup(long now) {
        int inUseConnectionCount = 0;
        int idleConnectionCount = 0;
        RealConnection longestIdleConnection = null;
        long longestIdleDurationNs = 0L;
        longestIdleDurationNs = Long.MIN_VALUE;
        for (RealConnection connection : this.connections) {
            Intrinsics.checkNotNullExpressionValue(connection, "connection");
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                Object object;
                int n;
                boolean bl = false;
                if (this.pruneAndGetAllocationCount(connection, now) > 0) {
                    n = inUseConnectionCount;
                    inUseConnectionCount = n + 1;
                    object = n;
                } else {
                    n = idleConnectionCount;
                    idleConnectionCount = n + 1;
                    long idleDurationNs = now - connection.getIdleAtNs$okhttp();
                    if (idleDurationNs > longestIdleDurationNs) {
                        longestIdleDurationNs = idleDurationNs;
                        longestIdleConnection = connection;
                    }
                    object = Unit.INSTANCE;
                }
                Integer n2 = object;
            }
        }
        if (longestIdleDurationNs >= this.keepAliveDurationNs || idleConnectionCount > this.maxIdleConnections) {
            RealConnection connection;
            RealConnection realConnection = longestIdleConnection;
            Intrinsics.checkNotNull(realConnection);
            RealConnection realConnection2 = connection = realConnection;
            synchronized (realConnection2) {
                block17: {
                    block16: {
                        boolean bl = false;
                        if (!(!((Collection)connection.getCalls()).isEmpty())) break block16;
                        long l = 0L;
                        return l;
                    }
                    if (connection.getIdleAtNs$okhttp() + longestIdleDurationNs == now) break block17;
                    long l = 0L;
                    return l;
                }
                connection.setNoNewExchanges(true);
                boolean bl = this.connections.remove(longestIdleConnection);
            }
            Util.closeQuietly(connection.socket());
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
        if (idleConnectionCount > 0) {
            return this.keepAliveDurationNs - longestIdleDurationNs;
        }
        if (inUseConnectionCount > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    private final int pruneAndGetAllocationCount(RealConnection connection, long now) {
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        List<Reference<RealCall>> references = connection.getCalls();
        int i = 0;
        while (i < references.size()) {
            Reference<RealCall> reference = references.get(i);
            if (reference.get() != null) {
                int n = i;
                i = n + 1;
                continue;
            }
            RealCall.CallReference callReference = (RealCall.CallReference)reference;
            String message = "A connection to " + connection.route().address().url() + " was leaked. Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(message, callReference.getCallStackTrace());
            references.remove(i);
            connection.setNoNewExchanges(true);
            if (!references.isEmpty()) continue;
            connection.setIdleAtNs$okhttp(now - this.keepAliveDurationNs);
            return 0;
        }
        return references.size();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

