/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;

public final class Request {
    private final HttpUrl url;
    private final String method;
    private final Headers headers;
    private final RequestBody body;
    private final Map<Class<?>, Object> tags;
    private CacheControl lazyCacheControl;

    public Request(HttpUrl url, String method, Headers headers, RequestBody body, Map<Class<?>, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(headers, "headers");
        Intrinsics.checkNotNullParameter(tags, "tags");
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.body = body;
        this.tags = tags;
    }

    public final HttpUrl url() {
        return this.url;
    }

    public final String method() {
        return this.method;
    }

    public final Headers headers() {
        return this.headers;
    }

    public final RequestBody body() {
        return this.body;
    }

    public final Map<Class<?>, Object> getTags$okhttp() {
        return this.tags;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    public final String header(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.headers.get(name);
    }

    public final List<String> headers(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.headers.values(name);
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final CacheControl cacheControl() {
        CacheControl result2 = this.lazyCacheControl;
        if (result2 == null) {
            this.lazyCacheControl = result2 = CacheControl.Companion.parse(this.headers);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2d1.append("Request{method=");
        $this$toString_u24lambda_u2d1.append(this.method());
        $this$toString_u24lambda_u2d1.append(", url=");
        $this$toString_u24lambda_u2d1.append(this.url());
        if (this.headers().size() != 0) {
            $this$toString_u24lambda_u2d1.append(", headers=[");
            Iterable $this$forEachIndexed$iv = this.headers();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void $dstr$name$value;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl2 = false;
                String name = (String)$dstr$name$value.component1();
                String value = (String)$dstr$name$value.component2();
                if (index > 0) {
                    $this$toString_u24lambda_u2d1.append(", ");
                }
                $this$toString_u24lambda_u2d1.append(name);
                $this$toString_u24lambda_u2d1.append(':');
                $this$toString_u24lambda_u2d1.append(value);
            }
            $this$toString_u24lambda_u2d1.append(']');
        }
        if (!this.getTags$okhttp().isEmpty()) {
            $this$toString_u24lambda_u2d1.append(", tags=");
            $this$toString_u24lambda_u2d1.append(this.getTags$okhttp());
        }
        $this$toString_u24lambda_u2d1.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static class Builder {
        private HttpUrl url;
        private String method;
        private Headers.Builder headers;
        private RequestBody body;
        private Map<Class<?>, Object> tags;

        public final void setUrl$okhttp(HttpUrl httpUrl) {
            this.url = httpUrl;
        }

        public final void setMethod$okhttp(String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.method = string;
        }

        public final Headers.Builder getHeaders$okhttp() {
            return this.headers;
        }

        public final void setHeaders$okhttp(Headers.Builder builder) {
            Intrinsics.checkNotNullParameter(builder, "<set-?>");
            this.headers = builder;
        }

        public final void setBody$okhttp(RequestBody requestBody) {
            this.body = requestBody;
        }

        public Builder() {
            this.tags = new LinkedHashMap();
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        public Builder(Request request) {
            Intrinsics.checkNotNullParameter(request, "request");
            this.tags = new LinkedHashMap();
            this.url = request.url();
            this.method = request.method();
            this.body = request.body();
            this.tags = request.getTags$okhttp().isEmpty() ? (Map)new LinkedHashMap() : MapsKt.toMutableMap(request.getTags$okhttp());
            this.headers = request.headers().newBuilder();
        }

        public Builder url(HttpUrl url) {
            Builder builder;
            Intrinsics.checkNotNullParameter(url, "url");
            Builder $this$url_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$url_u24lambda_u2d0.setUrl$okhttp(url);
            return builder;
        }

        public Builder url(String url) {
            String string;
            Intrinsics.checkNotNullParameter(url, "url");
            if (StringsKt.startsWith(url, "ws:", true)) {
                String string2 = url.substring(3);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
                string = Intrinsics.stringPlus("http:", string2);
            } else if (StringsKt.startsWith(url, "wss:", true)) {
                String string3 = url.substring(4);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).substring(startIndex)");
                string = Intrinsics.stringPlus("https:", string3);
            } else {
                string = url;
            }
            String finalUrl = string;
            return this.url(HttpUrl.Companion.get(finalUrl));
        }

        public Builder header(String name, String value) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(value, "value");
            Builder $this$header_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$header_u24lambda_u2d1.getHeaders$okhttp().set(name, value);
            return builder;
        }

        public Builder removeHeader(String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter(name, "name");
            Builder $this$removeHeader_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$removeHeader_u24lambda_u2d3.getHeaders$okhttp().removeAll(name);
            return builder;
        }

        public Builder headers(Headers headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, "headers");
            Builder $this$headers_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u2d4.setHeaders$okhttp(headers.newBuilder());
            return builder;
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder post(RequestBody body) {
            Intrinsics.checkNotNullParameter(body, "body");
            return this.method("POST", body);
        }

        public Builder method(String method, RequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter(method, "method");
            Builder $this$method_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            if (!(((CharSequence)method).length() > 0)) {
                boolean $i$a$-require-Request$Builder$method$1$42 = false;
                String $i$a$-require-Request$Builder$method$1$42 = "method.isEmpty() == true";
                throw new IllegalArgumentException($i$a$-require-Request$Builder$method$1$42.toString());
            }
            if (body == null) {
                if (!(!HttpMethod.requiresRequestBody(method))) {
                    boolean $i$a$-require-Request$Builder$method$1$52 = false;
                    String $i$a$-require-Request$Builder$method$1$52 = "method " + method + " must have a request body.";
                    throw new IllegalArgumentException($i$a$-require-Request$Builder$method$1$52.toString());
                }
            } else if (!HttpMethod.permitsRequestBody(method)) {
                boolean bl2 = false;
                String string = "method " + method + " must not have a request body.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$method_u24lambda_u2d8.setMethod$okhttp(method);
            $this$method_u24lambda_u2d8.setBody$okhttp(body);
            return builder;
        }

        public Request build() {
            HttpUrl httpUrl = this.url;
            if (httpUrl == null) {
                boolean bl = false;
                String string = "url == null";
                throw new IllegalStateException(string.toString());
            }
            Map<Class<?>, Object> map2 = Util.toImmutableMap(this.tags);
            RequestBody requestBody = this.body;
            Headers headers = this.headers.build();
            String string = this.method;
            HttpUrl httpUrl2 = httpUrl;
            return new Request(httpUrl2, string, headers, requestBody, map2);
        }
    }
}

