/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;

public final class CertificatePinner {
    public static final Companion Companion = new Companion(null);
    private final Set<Pin> pins;
    private final CertificateChainCleaner certificateChainCleaner;
    public static final CertificatePinner DEFAULT = new Builder().build();

    public CertificatePinner(Set<Pin> pins, CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkNotNullParameter(pins, "pins");
        this.pins = pins;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public /* synthetic */ CertificatePinner(Set set, CertificateChainCleaner certificateChainCleaner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            certificateChainCleaner = null;
        }
        this(set, certificateChainCleaner);
    }

    public final CertificateChainCleaner getCertificateChainCleaner$okhttp() {
        return this.certificateChainCleaner;
    }

    public final void check(String hostname, List<? extends Certificate> peerCertificates2) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        Intrinsics.checkNotNullParameter(peerCertificates2, "peerCertificates");
        this.check$okhttp(hostname, (Function0<? extends List<? extends X509Certificate>>)new Function0<List<? extends X509Certificate>>(this, peerCertificates2, hostname){
            final /* synthetic */ CertificatePinner this$0;
            final /* synthetic */ List<Certificate> $peerCertificates;
            final /* synthetic */ String $hostname;
            {
                this.this$0 = $receiver;
                this.$peerCertificates = $peerCertificates;
                this.$hostname = $hostname;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<X509Certificate> invoke() {
                void $this$mapTo$iv$iv;
                CertificateChainCleaner certificateChainCleaner = this.this$0.getCertificateChainCleaner$okhttp();
                List<Certificate> list = certificateChainCleaner == null ? null : certificateChainCleaner.clean(this.$peerCertificates, this.$hostname);
                if (list == null) {
                    list = this.$peerCertificates;
                }
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Certificate certificate = (Certificate)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((X509Certificate)it);
                }
                return (List)destination$iv$iv;
            }
        });
    }

    public final void check$okhttp(String hostname, Function0<? extends List<? extends X509Certificate>> cleanedPeerCertificatesFn) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        Intrinsics.checkNotNullParameter(cleanedPeerCertificatesFn, "cleanedPeerCertificatesFn");
        List<Pin> pins = this.findMatchingPins(hostname);
        if (pins.isEmpty()) {
            return;
        }
        List<? extends X509Certificate> peerCertificates2 = cleanedPeerCertificatesFn.invoke();
        for (X509Certificate stringBuilder2 : peerCertificates2) {
            ByteString sha1 = null;
            ByteString sha256 = null;
            for (Pin pin : pins) {
                String string = pin.getHashAlgorithm();
                if (Intrinsics.areEqual(string, "sha256")) {
                    if (sha256 == null) {
                        sha256 = Companion.sha256Hash(stringBuilder2);
                    }
                    if (!Intrinsics.areEqual(pin.getHash(), sha256)) continue;
                    return;
                }
                if (Intrinsics.areEqual(string, "sha1")) {
                    if (sha1 == null) {
                        sha1 = Companion.sha1Hash(stringBuilder2);
                    }
                    if (!Intrinsics.areEqual(pin.getHash(), sha1)) continue;
                    return;
                }
                throw new AssertionError((Object)Intrinsics.stringPlus("unsupported hashAlgorithm: ", pin.getHashAlgorithm()));
            }
        }
        StringBuilder $this$check_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$check_u24lambda_u2d0.append("Certificate pinning failure!");
        $this$check_u24lambda_u2d0.append("\n  Peer certificate chain:");
        for (X509Certificate x509Certificate : peerCertificates2) {
            $this$check_u24lambda_u2d0.append("\n    ");
            $this$check_u24lambda_u2d0.append(Companion.pin(x509Certificate));
            $this$check_u24lambda_u2d0.append(": ");
            $this$check_u24lambda_u2d0.append(x509Certificate.getSubjectDN().getName());
        }
        $this$check_u24lambda_u2d0.append("\n  Pinned certificates for ");
        $this$check_u24lambda_u2d0.append(hostname);
        $this$check_u24lambda_u2d0.append(":");
        for (Pin pin : pins) {
            $this$check_u24lambda_u2d0.append("\n    ");
            $this$check_u24lambda_u2d0.append(pin);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        String message = string;
        throw new SSLPeerUnverifiedException(message);
    }

    public final List<Pin> findMatchingPins(String hostname) {
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        Iterable $this$filterList$iv = this.pins;
        boolean $i$f$filterList = false;
        List result$iv = CollectionsKt.emptyList();
        for (Object i$iv : $this$filterList$iv) {
            Pin $this$findMatchingPins_u24lambda_u2d1 = (Pin)i$iv;
            boolean bl = false;
            if (!$this$findMatchingPins_u24lambda_u2d1.matchesHostname(hostname)) continue;
            if (result$iv.isEmpty()) {
                result$iv = new ArrayList();
            }
            TypeIntrinsics.asMutableList(result$iv).add(i$iv);
        }
        return result$iv;
    }

    public final CertificatePinner withCertificateChainCleaner$okhttp(CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkNotNullParameter(certificateChainCleaner, "certificateChainCleaner");
        return Intrinsics.areEqual(this.certificateChainCleaner, certificateChainCleaner) ? this : new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public boolean equals(Object other) {
        return other instanceof CertificatePinner && Intrinsics.areEqual(((CertificatePinner)other).pins, this.pins) && Intrinsics.areEqual(((CertificatePinner)other).certificateChainCleaner, this.certificateChainCleaner);
    }

    public int hashCode() {
        int result2 = 37;
        result2 = 41 * result2 + ((Object)this.pins).hashCode();
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        result2 = 41 * result2 + (certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0);
        return result2;
    }

    public static final class Pin {
        private final String pattern;
        private final String hashAlgorithm;
        private final ByteString hash;

        public final String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        public final ByteString getHash() {
            return this.hash;
        }

        public final boolean matchesHostname(String hostname) {
            boolean bl;
            Intrinsics.checkNotNullParameter(hostname, "hostname");
            if (StringsKt.startsWith$default(this.pattern, "**.", false, 2, null)) {
                int suffixLength = this.pattern.length() - 3;
                int prefixLength = hostname.length() - suffixLength;
                bl = StringsKt.regionMatches$default(hostname, hostname.length() - suffixLength, this.pattern, 3, suffixLength, false, 16, null) && (prefixLength == 0 || hostname.charAt(prefixLength - 1) == '.');
            } else if (StringsKt.startsWith$default(this.pattern, "*.", false, 2, null)) {
                int suffixLength = this.pattern.length() - 1;
                int prefixLength = hostname.length() - suffixLength;
                bl = StringsKt.regionMatches$default(hostname, hostname.length() - suffixLength, this.pattern, 1, suffixLength, false, 16, null) && StringsKt.lastIndexOf$default((CharSequence)hostname, '.', prefixLength - 1, false, 4, null) == -1;
            } else {
                bl = Intrinsics.areEqual(hostname, this.pattern);
            }
            return bl;
        }

        public String toString() {
            return this.hashAlgorithm + '/' + this.hash.base64();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Pin)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pattern, ((Pin)other).pattern)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.hashAlgorithm, ((Pin)other).hashAlgorithm)) {
                return false;
            }
            return Intrinsics.areEqual(this.hash, ((Pin)other).hash);
        }

        public int hashCode() {
            int result2 = this.pattern.hashCode();
            result2 = 31 * result2 + this.hashAlgorithm.hashCode();
            result2 = 31 * result2 + this.hash.hashCode();
            return result2;
        }
    }

    public static final class Builder {
        private final List<Pin> pins = new ArrayList();

        public final CertificatePinner build() {
            return new CertificatePinner(CollectionsKt.toSet((Iterable)this.pins), null, 2, null);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final ByteString sha1Hash(X509Certificate $this$sha1Hash) {
            Intrinsics.checkNotNullParameter($this$sha1Hash, "<this>");
            byte[] byArray = $this$sha1Hash.getPublicKey().getEncoded();
            Intrinsics.checkNotNullExpressionValue(byArray, "publicKey.encoded");
            return ByteString.Companion.of$default(ByteString.Companion, byArray, 0, 0, 3, null).sha1();
        }

        public final ByteString sha256Hash(X509Certificate $this$sha256Hash) {
            Intrinsics.checkNotNullParameter($this$sha256Hash, "<this>");
            byte[] byArray = $this$sha256Hash.getPublicKey().getEncoded();
            Intrinsics.checkNotNullExpressionValue(byArray, "publicKey.encoded");
            return ByteString.Companion.of$default(ByteString.Companion, byArray, 0, 0, 3, null).sha256();
        }

        public final String pin(Certificate certificate) {
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            if (!(certificate instanceof X509Certificate)) {
                boolean bl = false;
                String string = "Certificate pinning requires X509 certificates";
                throw new IllegalArgumentException(string.toString());
            }
            return Intrinsics.stringPlus("sha256/", this.sha256Hash((X509Certificate)certificate).base64());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

