/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.modules.SerializersModule;

public final class JsonBuilder {
    private boolean encodeDefaults;
    private boolean explicitNulls;
    private boolean ignoreUnknownKeys;
    private boolean isLenient;
    private boolean prettyPrint;
    private String prettyPrintIndent;
    private boolean coerceInputValues;
    private String classDiscriminator;
    private ClassDiscriminatorMode classDiscriminatorMode;
    private boolean useAlternativeNames;
    private JsonNamingStrategy namingStrategy;
    private boolean decodeEnumsCaseInsensitive;
    private boolean allowTrailingComma;
    private boolean allowComments;
    private boolean allowSpecialFloatingPointValues;
    private boolean allowStructuredMapKeys;
    private boolean useArrayPolymorphism;
    private SerializersModule serializersModule;

    public JsonBuilder(Json json) {
        Intrinsics.checkNotNullParameter(json, "json");
        this.encodeDefaults = json.getConfiguration().getEncodeDefaults();
        this.explicitNulls = json.getConfiguration().getExplicitNulls();
        this.ignoreUnknownKeys = json.getConfiguration().getIgnoreUnknownKeys();
        this.isLenient = json.getConfiguration().isLenient();
        this.prettyPrint = json.getConfiguration().getPrettyPrint();
        this.prettyPrintIndent = json.getConfiguration().getPrettyPrintIndent();
        this.coerceInputValues = json.getConfiguration().getCoerceInputValues();
        this.classDiscriminator = json.getConfiguration().getClassDiscriminator();
        this.classDiscriminatorMode = json.getConfiguration().getClassDiscriminatorMode();
        this.useAlternativeNames = json.getConfiguration().getUseAlternativeNames();
        this.namingStrategy = json.getConfiguration().getNamingStrategy();
        this.decodeEnumsCaseInsensitive = json.getConfiguration().getDecodeEnumsCaseInsensitive();
        this.allowTrailingComma = json.getConfiguration().getAllowTrailingComma();
        this.allowComments = json.getConfiguration().getAllowComments();
        this.allowSpecialFloatingPointValues = json.getConfiguration().getAllowSpecialFloatingPointValues();
        this.allowStructuredMapKeys = json.getConfiguration().getAllowStructuredMapKeys();
        this.useArrayPolymorphism = json.getConfiguration().getUseArrayPolymorphism();
        this.serializersModule = json.getSerializersModule();
    }

    public final void setPrettyPrint(boolean bl) {
        this.prettyPrint = bl;
    }

    public final SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public final JsonConfiguration build$kotlinx_serialization_json() {
        if (this.useArrayPolymorphism) {
            if (!Intrinsics.areEqual(this.classDiscriminator, "type")) {
                boolean $i$a$-require-JsonBuilder$build$52 = false;
                String $i$a$-require-JsonBuilder$build$52 = "Class discriminator should not be specified when array polymorphism is specified";
                throw new IllegalArgumentException($i$a$-require-JsonBuilder$build$52.toString());
            }
            if (!(this.classDiscriminatorMode == ClassDiscriminatorMode.POLYMORPHIC)) {
                boolean $i$a$-require-JsonBuilder$build$62 = false;
                String $i$a$-require-JsonBuilder$build$62 = "useArrayPolymorphism option can only be used if classDiscriminatorMode in a default POLYMORPHIC state.";
                throw new IllegalArgumentException($i$a$-require-JsonBuilder$build$62.toString());
            }
        }
        if (!this.prettyPrint) {
            if (!Intrinsics.areEqual(this.prettyPrintIndent, "    ")) {
                boolean $i$a$-require-JsonBuilder$build$72 = false;
                String $i$a$-require-JsonBuilder$build$72 = "Indent should not be specified when default printing mode is used";
                throw new IllegalArgumentException($i$a$-require-JsonBuilder$build$72.toString());
            }
        } else if (!Intrinsics.areEqual(this.prettyPrintIndent, "    ")) {
            boolean allWhitespaces;
            block9: {
                boolean bl;
                CharSequence $this$all$iv = this.prettyPrintIndent;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (it == ' ' || it == '\t' || it == '\r' || it == '\n') continue;
                    bl = false;
                    break block9;
                }
                bl = allWhitespaces = true;
            }
            if (!allWhitespaces) {
                boolean bl = false;
                String string = "Only whitespace, tab, newline and carriage return are allowed as pretty print symbols. Had " + this.prettyPrintIndent;
                throw new IllegalArgumentException(string.toString());
            }
        }
        return new JsonConfiguration(this.encodeDefaults, this.ignoreUnknownKeys, this.isLenient, this.allowStructuredMapKeys, this.prettyPrint, this.explicitNulls, this.prettyPrintIndent, this.coerceInputValues, this.useArrayPolymorphism, this.classDiscriminator, this.allowSpecialFloatingPointValues, this.useAlternativeNames, this.namingStrategy, this.decodeEnumsCaseInsensitive, this.allowTrailingComma, this.allowComments, this.classDiscriminatorMode);
    }
}

