/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ListBuilder<E>
extends AbstractMutableList<E>
implements Serializable,
List<E>,
RandomAccess {
    private static final Companion Companion;
    private E[] backing;
    private int length;
    private boolean isReadOnly;
    private static final ListBuilder Empty;

    public ListBuilder(int initialCapacity) {
        this.backing = ListBuilderKt.arrayOfUninitializedElements(initialCapacity);
    }

    public /* synthetic */ ListBuilder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    public final List<E> build() {
        this.checkIsMutable();
        this.isReadOnly = true;
        return this.length > 0 ? (List)this : (List)Empty;
    }

    @Override
    public int getSize() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public E get(int index) {
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        return this.backing[index];
    }

    @Override
    public E set(int index, E element) {
        this.checkIsMutable();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        E old = this.backing[index];
        this.backing[index] = element;
        return old;
    }

    @Override
    public int indexOf(Object element) {
        for (int i = 0; i < this.length; ++i) {
            if (!Intrinsics.areEqual(this.backing[i], element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual(this.backing[i], element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        return new Itr(this, index);
    }

    @Override
    public boolean add(E element) {
        this.checkIsMutable();
        this.addAtInternal(this.length, element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.checkIsMutable();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        this.addAtInternal(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        int n = elements.size();
        this.addAllInternal(this.length, elements, n);
        return n > 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        int n = elements.size();
        this.addAllInternal(index, elements, n);
        return n > 0;
    }

    @Override
    public void clear() {
        this.checkIsMutable();
        this.removeRangeInternal(0, this.length);
    }

    @Override
    public E removeAt(int index) {
        this.checkIsMutable();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        return this.removeAtInternal(index);
    }

    @Override
    public boolean remove(Object element) {
        this.checkIsMutable();
        int i = this.indexOf(element);
        if (i >= 0) {
            this.remove(i);
        }
        return i >= 0;
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        return this.retainOrRemoveAllInternal(0, this.length, elements, false) > 0;
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        return this.retainOrRemoveAllInternal(0, this.length, elements, true) > 0;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(fromIndex, toIndex, this.length);
        return new BuilderSubList<E>(this.backing, fromIndex, toIndex - fromIndex, null, this);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        if (array.length < this.length) {
            T[] TArray = Arrays.copyOfRange(this.backing, 0, this.length, array.getClass());
            Intrinsics.checkNotNullExpressionValue(TArray, "copyOfRange(...)");
            return TArray;
        }
        ArraysKt.copyInto(this.backing, array, 0, 0, this.length);
        return CollectionsKt.terminateCollectionToArray(this.length, array);
    }

    @Override
    public Object[] toArray() {
        E[] EArray = this.backing;
        int n = 0;
        int n2 = this.length;
        return ArraysKt.copyOfRange(EArray, n, n2);
    }

    @Override
    public boolean equals(Object other) {
        return other == this || other instanceof List && this.contentEquals((List)other);
    }

    @Override
    public int hashCode() {
        return ListBuilderKt.access$subarrayContentHashCode(this.backing, 0, this.length);
    }

    @Override
    public String toString() {
        return ListBuilderKt.access$subarrayContentToString(this.backing, 0, this.length, this);
    }

    private final void registerModification() {
        ++this.modCount;
    }

    private final void checkIsMutable() {
        if (this.isReadOnly) {
            throw new UnsupportedOperationException();
        }
    }

    private final void ensureExtraCapacity(int n) {
        this.ensureCapacityInternal(this.length + n);
    }

    private final void ensureCapacityInternal(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        if (minCapacity > this.backing.length) {
            int newSize = AbstractList.Companion.newCapacity$kotlin_stdlib(this.backing.length, minCapacity);
            this.backing = ListBuilderKt.copyOfUninitializedElements(this.backing, newSize);
        }
    }

    private final boolean contentEquals(List<?> other) {
        return ListBuilderKt.access$subarrayContentEquals(this.backing, 0, this.length, other);
    }

    private final void insertAtInternal(int i, int n) {
        this.ensureExtraCapacity(n);
        E[] EArray = this.backing;
        E[] EArray2 = this.backing;
        int n2 = this.length;
        int n3 = i + n;
        ArraysKt.copyInto(EArray, EArray2, n3, i, n2);
        this.length += n;
    }

    private final void addAtInternal(int i, E element) {
        this.registerModification();
        this.insertAtInternal(i, 1);
        this.backing[i] = element;
    }

    private final void addAllInternal(int i, Collection<? extends E> elements, int n) {
        this.registerModification();
        this.insertAtInternal(i, n);
        Iterator<E> it = elements.iterator();
        for (int j = 0; j < n; ++j) {
            this.backing[i + j] = it.next();
        }
    }

    private final E removeAtInternal(int i) {
        this.registerModification();
        E old = this.backing[i];
        E[] EArray = this.backing;
        E[] EArray2 = this.backing;
        int n = i + 1;
        int n2 = this.length;
        ArraysKt.copyInto(EArray, EArray2, i, n, n2);
        ListBuilderKt.resetAt(this.backing, this.length - 1);
        int n3 = this.length;
        this.length = n3 + -1;
        return old;
    }

    private final void removeRangeInternal(int rangeOffset, int rangeLength) {
        if (rangeLength > 0) {
            this.registerModification();
        }
        E[] EArray = this.backing;
        E[] EArray2 = this.backing;
        int n = rangeOffset + rangeLength;
        int n2 = this.length;
        ArraysKt.copyInto(EArray, EArray2, rangeOffset, n, n2);
        ListBuilderKt.resetRange(this.backing, this.length - rangeLength, this.length);
        this.length -= rangeLength;
    }

    private final int retainOrRemoveAllInternal(int rangeOffset, int rangeLength, Collection<? extends E> elements, boolean retain) {
        int i = 0;
        int j = 0;
        while (i < rangeLength) {
            if (elements.contains(this.backing[rangeOffset + i]) == retain) {
                this.backing[rangeOffset + j++] = this.backing[rangeOffset + i++];
                continue;
            }
            ++i;
        }
        int removed = rangeLength - j;
        E[] EArray = this.backing;
        E[] EArray2 = this.backing;
        int n = rangeOffset + rangeLength;
        int n2 = this.length;
        int n3 = rangeOffset + j;
        ArraysKt.copyInto(EArray, EArray2, n3, n, n2);
        ListBuilderKt.resetRange(this.backing, this.length - removed, this.length);
        if (removed > 0) {
            this.registerModification();
        }
        this.length -= removed;
        return removed;
    }

    public ListBuilder() {
        this(0, 1, null);
    }

    static {
        ListBuilder listBuilder;
        Companion = new Companion(null);
        ListBuilder it = listBuilder = new ListBuilder(0);
        boolean bl = false;
        it.isReadOnly = true;
        Empty = listBuilder;
    }

    public static final class BuilderSubList<E>
    extends AbstractMutableList<E>
    implements Serializable,
    List<E>,
    RandomAccess {
        private E[] backing;
        private final int offset;
        private int length;
        private final BuilderSubList<E> parent;
        private final ListBuilder<E> root;

        public BuilderSubList(E[] backing, int offset, int length, BuilderSubList<E> parent, ListBuilder<E> root) {
            Intrinsics.checkNotNullParameter(backing, "backing");
            Intrinsics.checkNotNullParameter(root, "root");
            this.backing = backing;
            this.offset = offset;
            this.length = length;
            this.parent = parent;
            this.root = root;
            this.modCount = ((ListBuilder)this.root).modCount;
        }

        @Override
        public int getSize() {
            this.checkForComodification();
            return this.length;
        }

        @Override
        public boolean isEmpty() {
            this.checkForComodification();
            return this.length == 0;
        }

        @Override
        public E get(int index) {
            this.checkForComodification();
            AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
            return this.backing[this.offset + index];
        }

        @Override
        public E set(int index, E element) {
            this.checkIsMutable();
            this.checkForComodification();
            AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
            E old = this.backing[this.offset + index];
            this.backing[this.offset + index] = element;
            return old;
        }

        @Override
        public int indexOf(Object element) {
            this.checkForComodification();
            for (int i = 0; i < this.length; ++i) {
                if (!Intrinsics.areEqual(this.backing[this.offset + i], element)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object element) {
            this.checkForComodification();
            for (int i = this.length - 1; i >= 0; --i) {
                if (!Intrinsics.areEqual(this.backing[this.offset + i], element)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            this.checkForComodification();
            AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
            return new Itr(this, index);
        }

        @Override
        public boolean add(E element) {
            this.checkIsMutable();
            this.checkForComodification();
            this.addAtInternal(this.offset + this.length, element);
            return true;
        }

        @Override
        public void add(int index, E element) {
            this.checkIsMutable();
            this.checkForComodification();
            AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
            this.addAtInternal(this.offset + index, element);
        }

        @Override
        public boolean addAll(Collection<? extends E> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.checkIsMutable();
            this.checkForComodification();
            int n = elements.size();
            this.addAllInternal(this.offset + this.length, elements, n);
            return n > 0;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.checkIsMutable();
            this.checkForComodification();
            AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
            int n = elements.size();
            this.addAllInternal(this.offset + index, elements, n);
            return n > 0;
        }

        @Override
        public void clear() {
            this.checkIsMutable();
            this.checkForComodification();
            this.removeRangeInternal(this.offset, this.length);
        }

        @Override
        public E removeAt(int index) {
            this.checkIsMutable();
            this.checkForComodification();
            AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
            return this.removeAtInternal(this.offset + index);
        }

        @Override
        public boolean remove(Object element) {
            this.checkIsMutable();
            this.checkForComodification();
            int i = this.indexOf(element);
            if (i >= 0) {
                this.remove(i);
            }
            return i >= 0;
        }

        @Override
        public boolean removeAll(Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.checkIsMutable();
            this.checkForComodification();
            return this.retainOrRemoveAllInternal(this.offset, this.length, elements, false) > 0;
        }

        @Override
        public boolean retainAll(Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            this.checkIsMutable();
            this.checkForComodification();
            return this.retainOrRemoveAllInternal(this.offset, this.length, elements, true) > 0;
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(fromIndex, toIndex, this.length);
            return new BuilderSubList<E>(this.backing, this.offset + fromIndex, toIndex - fromIndex, this, this.root);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, "array");
            this.checkForComodification();
            if (array.length < this.length) {
                T[] TArray = Arrays.copyOfRange(this.backing, this.offset, this.offset + this.length, array.getClass());
                Intrinsics.checkNotNullExpressionValue(TArray, "copyOfRange(...)");
                return TArray;
            }
            ArraysKt.copyInto(this.backing, array, 0, this.offset, this.offset + this.length);
            return CollectionsKt.terminateCollectionToArray(this.length, array);
        }

        @Override
        public Object[] toArray() {
            this.checkForComodification();
            E[] EArray = this.backing;
            int n = this.offset;
            int n2 = this.offset + this.length;
            return ArraysKt.copyOfRange(EArray, n, n2);
        }

        @Override
        public boolean equals(Object other) {
            this.checkForComodification();
            return other == this || other instanceof List && this.contentEquals((List)other);
        }

        @Override
        public int hashCode() {
            this.checkForComodification();
            return ListBuilderKt.access$subarrayContentHashCode(this.backing, this.offset, this.length);
        }

        @Override
        public String toString() {
            this.checkForComodification();
            return ListBuilderKt.access$subarrayContentToString(this.backing, this.offset, this.length, this);
        }

        private final void registerModification() {
            ++this.modCount;
        }

        private final void checkForComodification() {
            if (((ListBuilder)this.root).modCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private final void checkIsMutable() {
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException();
            }
        }

        private final boolean isReadOnly() {
            return ((ListBuilder)this.root).isReadOnly;
        }

        private final boolean contentEquals(List<?> other) {
            return ListBuilderKt.access$subarrayContentEquals(this.backing, this.offset, this.length, other);
        }

        private final void addAtInternal(int i, E element) {
            this.registerModification();
            if (this.parent != null) {
                super.addAtInternal(i, element);
            } else {
                ((ListBuilder)this.root).addAtInternal(i, element);
            }
            this.backing = ((ListBuilder)this.root).backing;
            int n = this.length;
            this.length = n + 1;
        }

        private final void addAllInternal(int i, Collection<? extends E> elements, int n) {
            this.registerModification();
            if (this.parent != null) {
                super.addAllInternal(i, elements, n);
            } else {
                ((ListBuilder)this.root).addAllInternal(i, elements, n);
            }
            this.backing = ((ListBuilder)this.root).backing;
            this.length += n;
        }

        private final E removeAtInternal(int i) {
            this.registerModification();
            Object old = this.parent != null ? super.removeAtInternal(i) : ((ListBuilder)this.root).removeAtInternal(i);
            int n = this.length;
            this.length = n + -1;
            return old;
        }

        private final void removeRangeInternal(int rangeOffset, int rangeLength) {
            if (rangeLength > 0) {
                this.registerModification();
            }
            if (this.parent != null) {
                super.removeRangeInternal(rangeOffset, rangeLength);
            } else {
                ((ListBuilder)this.root).removeRangeInternal(rangeOffset, rangeLength);
            }
            this.length -= rangeLength;
        }

        private final int retainOrRemoveAllInternal(int rangeOffset, int rangeLength, Collection<? extends E> elements, boolean retain) {
            int removed;
            int n = removed = this.parent != null ? super.retainOrRemoveAllInternal(rangeOffset, rangeLength, elements, retain) : ((ListBuilder)this.root).retainOrRemoveAllInternal(rangeOffset, rangeLength, elements, retain);
            if (removed > 0) {
                this.registerModification();
            }
            this.length -= removed;
            return removed;
        }

        private static final class Itr<E>
        implements ListIterator<E>,
        KMutableListIterator {
            private final BuilderSubList<E> list;
            private int index;
            private int lastIndex;
            private int expectedModCount;

            public Itr(BuilderSubList<E> list, int index) {
                Intrinsics.checkNotNullParameter(list, "list");
                this.list = list;
                this.index = index;
                this.lastIndex = -1;
                this.expectedModCount = ((BuilderSubList)this.list).modCount;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < ((BuilderSubList)this.list).length;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public E previous() {
                this.checkForComodification();
                if (this.index <= 0) {
                    throw new NoSuchElementException();
                }
                this.index += -1;
                this.lastIndex = this.index;
                return (E)((BuilderSubList)this.list).backing[((BuilderSubList)this.list).offset + this.lastIndex];
            }

            @Override
            public E next() {
                this.checkForComodification();
                if (this.index >= ((BuilderSubList)this.list).length) {
                    throw new NoSuchElementException();
                }
                int n = this.index;
                this.index = n + 1;
                this.lastIndex = n;
                return (E)((BuilderSubList)this.list).backing[((BuilderSubList)this.list).offset + this.lastIndex];
            }

            @Override
            public void set(E element) {
                boolean bl;
                this.checkForComodification();
                boolean bl2 = bl = this.lastIndex != -1;
                if (!bl) {
                    boolean bl3 = false;
                    String string = "Call next() or previous() before replacing element from the iterator.";
                    throw new IllegalStateException(string.toString());
                }
                this.list.set(this.lastIndex, element);
            }

            @Override
            public void add(E element) {
                this.checkForComodification();
                int n = this.index;
                this.index = n + 1;
                this.list.add(n, element);
                this.lastIndex = -1;
                this.expectedModCount = ((BuilderSubList)this.list).modCount;
            }

            @Override
            public void remove() {
                boolean bl;
                this.checkForComodification();
                boolean bl2 = bl = this.lastIndex != -1;
                if (!bl) {
                    boolean bl3 = false;
                    String string = "Call next() or previous() before removing element from the iterator.";
                    throw new IllegalStateException(string.toString());
                }
                this.list.remove(this.lastIndex);
                this.index = this.lastIndex;
                this.lastIndex = -1;
                this.expectedModCount = ((BuilderSubList)this.list).modCount;
            }

            private final void checkForComodification() {
                if (((BuilderSubList)this.list).root.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class Itr<E>
    implements ListIterator<E>,
    KMutableListIterator {
        private final ListBuilder<E> list;
        private int index;
        private int lastIndex;
        private int expectedModCount;

        public Itr(ListBuilder<E> list, int index) {
            Intrinsics.checkNotNullParameter(list, "list");
            this.list = list;
            this.index = index;
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)this.list).modCount;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < ((ListBuilder)this.list).length;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            this.index += -1;
            this.lastIndex = this.index;
            return (E)((ListBuilder)this.list).backing[this.lastIndex];
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (this.index >= ((ListBuilder)this.list).length) {
                throw new NoSuchElementException();
            }
            int n = this.index;
            this.index = n + 1;
            this.lastIndex = n;
            return (E)((ListBuilder)this.list).backing[this.lastIndex];
        }

        @Override
        public void set(E element) {
            boolean bl;
            this.checkForComodification();
            boolean bl2 = bl = this.lastIndex != -1;
            if (!bl) {
                boolean bl3 = false;
                String string = "Call next() or previous() before replacing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.list.set(this.lastIndex, element);
        }

        @Override
        public void add(E element) {
            this.checkForComodification();
            int n = this.index;
            this.index = n + 1;
            this.list.add(n, element);
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)this.list).modCount;
        }

        @Override
        public void remove() {
            boolean bl;
            this.checkForComodification();
            boolean bl2 = bl = this.lastIndex != -1;
            if (!bl) {
                boolean bl3 = false;
                String string = "Call next() or previous() before removing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.list.remove(this.lastIndex);
            this.index = this.lastIndex;
            this.lastIndex = -1;
            this.expectedModCount = ((ListBuilder)this.list).modCount;
        }

        private final void checkForComodification() {
            if (((ListBuilder)this.list).modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

