/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.SCPException;
import net.schmizz.sshj.xfer.scp.SCPRemoteException;
import net.schmizz.sshj.xfer.scp.ScpCommandLine;
import org.slf4j.Logger;

class SCPEngine {
    private static final char LF = '\n';
    private final LoggerFactory loggerFactory;
    private final Logger log;
    private final SessionFactory host;
    private final TransferListener listener;
    private Session session;
    private Session.Command scp;
    private int exitStatus;

    SCPEngine(SessionFactory host, TransferListener listener, LoggerFactory loggerFactory) {
        this.host = host;
        this.listener = listener;
        this.loggerFactory = loggerFactory;
        this.log = loggerFactory.getLogger(this.getClass());
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    void check(String what) throws IOException {
        int code = this.scp.getInputStream().read();
        switch (code) {
            case -1: {
                Object stderr = IOUtils.readFully(this.scp.getErrorStream(), this.loggerFactory).toString();
                if (!((String)stderr).isEmpty()) {
                    stderr = ". Additional info: `" + (String)stderr + "`";
                }
                throw new SCPException("EOF while expecting response to protocol message" + (String)stderr);
            }
            case 0: {
                this.log.debug(what);
                return;
            }
            case 1: 
            case 2: {
                String remoteMessage = this.readMessage();
                throw new SCPRemoteException("Remote SCP command had error: " + remoteMessage, remoteMessage);
            }
        }
        throw new SCPException("Received unknown response code");
    }

    void cleanSlate() {
        this.exitStatus = -1;
    }

    void execSCPWith(ScpCommandLine commandLine) throws SSHException {
        this.session = this.host.startSession();
        this.scp = this.session.exec(commandLine.toCommandLine());
    }

    void exit() {
        if (this.scp != null) {
            IOUtils.closeQuietly(this.scp);
            if (this.scp.getExitStatus() != null) {
                this.exitStatus = this.scp.getExitStatus();
                if (this.scp.getExitStatus() != 0) {
                    this.log.warn("SCP exit status: {}", (Object)this.scp.getExitStatus());
                }
            } else {
                this.exitStatus = -1;
            }
            if (this.scp.getExitSignal() != null) {
                this.log.warn("SCP exit signal: {}", (Object)this.scp.getExitSignal());
            }
        }
        if (this.session != null) {
            IOUtils.closeQuietly(this.session);
            this.session = null;
        }
        this.scp = null;
    }

    String readMessage() throws IOException {
        int x;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((x = this.scp.getInputStream().read()) != 10) {
            if (x == -1) {
                if (baos.size() == 0) {
                    return "";
                }
                throw new IOException("EOF while reading message");
            }
            baos.write(x);
        }
        String msg = baos.toString(IOUtils.UTF8.displayName());
        this.log.debug("Read message: `{}`", (Object)msg);
        return msg;
    }

    void sendMessage(String msg) throws IOException {
        this.log.debug("Sending message: {}", (Object)msg);
        this.scp.getOutputStream().write((msg + "\n").getBytes(this.scp.getRemoteCharset()));
        this.scp.getOutputStream().flush();
        this.check("Message ACK received");
    }

    void signal(String what) throws IOException {
        this.log.debug("Signalling: {}", (Object)what);
        this.scp.getOutputStream().write(0);
        this.scp.getOutputStream().flush();
    }

    long transferToRemote(StreamCopier.Listener listener, InputStream src, long length) throws IOException {
        return new StreamCopier(src, this.scp.getOutputStream(), this.loggerFactory).bufSize(this.scp.getRemoteMaxPacketSize()).length(length).keepFlushing(false).listener(listener).copy();
    }

    long transferFromRemote(StreamCopier.Listener listener, OutputStream dest, long length) throws IOException {
        return new StreamCopier(this.scp.getInputStream(), dest, this.loggerFactory).bufSize(this.scp.getLocalMaxPacketSize()).length(length).keepFlushing(false).listener(listener).copy();
    }

    TransferListener getTransferListener() {
        return this.listener;
    }
}

