// Generated by IcedCoffeeScript 108.0.8
(function() {
  var Global, Hasher, SHA256, WordArray, glbl, transform,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  WordArray = require('./wordarray').WordArray;

  Hasher = require('./algbase').Hasher;

  Global = (function() {
    function Global() {
      this.H = [];
      this.K = [];
      this.W = [];
      this.init();
    }

    Global.prototype.isPrime = function(n) {
      var f, sqn, _i;
      if (n === 2 || n === 3 || n === 5 || n === 7) {
        return true;
      }
      if (n === 1 || n === 4 || n === 6 || n === 8 || n === 9) {
        return false;
      }
      sqn = Math.ceil(Math.sqrt(n));
      for (f = _i = 2; 2 <= sqn ? _i <= sqn : _i >= sqn; f = 2 <= sqn ? ++_i : --_i) {
        if ((n % f) === 0) {
          return false;
        }
      }
      return true;
    };

    Global.prototype.getFractionalBits = function(n) {
      return ((n - (n | 0)) * 0x100000000) | 0;
    };

    Global.prototype.init = function() {
      var n, nPrime, _results;
      n = 2;
      nPrime = 0;
      _results = [];
      while (nPrime < 64) {
        if (this.isPrime(n)) {
          if (nPrime < 8) {
            this.H[nPrime] = this.getFractionalBits(Math.pow(n, 1 / 2));
          }
          this.K[nPrime] = this.getFractionalBits(Math.pow(n, 1 / 3));
          nPrime++;
        }
        _results.push(n++);
      }
      return _results;
    };

    return Global;

  })();

  glbl = new Global();

  SHA256 = (function(_super) {
    __extends(SHA256, _super);

    function SHA256() {
      return SHA256.__super__.constructor.apply(this, arguments);
    }

    SHA256.blockSize = 512 / 32;

    SHA256.prototype.blockSize = SHA256.blockSize;

    SHA256.output_size = 256 / 8;

    SHA256.prototype.output_size = SHA256.output_size;

    SHA256.prototype._doReset = function() {
      return this._hash = new WordArray(glbl.H.slice(0));
    };

    SHA256.prototype.get_output_size = function() {
      return this.output_size;
    };

    SHA256.prototype._doProcessBlock = function(M, offset) {
      var H, K, W, a, b, c, ch, d, e, f, g, gamma0, gamma0x, gamma1, gamma1x, h, i, maj, sigma0, sigma1, t1, t2, _i;
      H = this._hash.words;
      W = glbl.W;
      K = glbl.K;
      a = H[0];
      b = H[1];
      c = H[2];
      d = H[3];
      e = H[4];
      f = H[5];
      g = H[6];
      h = H[7];
      for (i = _i = 0; _i < 64; i = ++_i) {
        if (i < 16) {
          W[i] = M[offset + i] | 0;
        } else {
          gamma0x = W[i - 15];
          gamma0 = ((gamma0x << 25) | (gamma0x >>> 7)) ^ ((gamma0x << 14) | (gamma0x >>> 18)) ^ (gamma0x >>> 3);
          gamma1x = W[i - 2];
          gamma1 = ((gamma1x << 15) | (gamma1x >>> 17)) ^ ((gamma1x << 13) | (gamma1x >>> 19)) ^ (gamma1x >>> 10);
          W[i] = gamma0 + W[i - 7] + gamma1 + W[i - 16];
        }
        ch = (e & f) ^ (~e & g);
        maj = (a & b) ^ (a & c) ^ (b & c);
        sigma0 = ((a << 30) | (a >>> 2)) ^ ((a << 19) | (a >>> 13)) ^ ((a << 10) | (a >>> 22));
        sigma1 = ((e << 26) | (e >>> 6)) ^ ((e << 21) | (e >>> 11)) ^ ((e << 7) | (e >>> 25));
        t1 = h + sigma1 + ch + K[i] + W[i];
        t2 = sigma0 + maj;
        h = g;
        g = f;
        f = e;
        e = (d + t1) | 0;
        d = c;
        c = b;
        b = a;
        a = (t1 + t2) | 0;
      }
      H[0] = (H[0] + a) | 0;
      H[1] = (H[1] + b) | 0;
      H[2] = (H[2] + c) | 0;
      H[3] = (H[3] + d) | 0;
      H[4] = (H[4] + e) | 0;
      H[5] = (H[5] + f) | 0;
      H[6] = (H[6] + g) | 0;
      return H[7] = (H[7] + h) | 0;
    };

    SHA256.prototype._doFinalize = function() {
      var data, dataWords, nBitsLeft, nBitsTotal;
      data = this._data;
      dataWords = data.words;
      nBitsTotal = this._nDataBytes * 8;
      nBitsLeft = data.sigBytes * 8;
      dataWords[nBitsLeft >>> 5] |= 0x80 << (24 - nBitsLeft % 32);
      dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 14] = Math.floor(nBitsTotal / 0x100000000);
      dataWords[(((nBitsLeft + 64) >>> 9) << 4) + 15] = nBitsTotal;
      data.sigBytes = dataWords.length * 4;
      this._process();
      return this._hash;
    };

    SHA256.prototype.scrub = function() {
      return this._hash.scrub();
    };

    SHA256.prototype.copy_to = function(obj) {
      SHA256.__super__.copy_to.call(this, obj);
      return obj._hash = this._hash.clone();
    };

    SHA256.prototype.clone = function() {
      var out;
      out = new SHA256();
      this.copy_to(out);
      return out;
    };

    return SHA256;

  })(Hasher);

  transform = function(x) {
    var out;
    out = (new SHA256).finalize(x);
    x.scrub();
    return out;
  };

  exports.SHA256 = SHA256;

  exports.transform = transform;

}).call(this);
