// Generated by IcedCoffeeScript 108.0.11
(function() {
  var Base, Sodium, bufeq_secure,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  bufeq_secure = require('./util').bufeq_secure;

  Base = require('./base').Base;

  exports.Sodium = Sodium = (function(_super) {
    __extends(Sodium, _super);

    function Sodium() {
      return Sodium.__super__.constructor.apply(this, arguments);
    }

    Sodium.prototype._detach = function(sig) {
      var l;
      l = this.lib.c.crypto_sign_BYTES;
      return {
        sig: sig.slice(0, l),
        payload: sig.slice(l)
      };
    };

    Sodium.prototype._pad = function(x) {
      return Buffer.concat([Buffer.alloc(16), x]);
    };

    Sodium.prototype._unpad = function(x) {
      return x.slice(16);
    };

    Sodium.prototype.verify = function(_arg) {
      var detached, err, msg, payload, r_payload, sig;
      payload = _arg.payload, sig = _arg.sig, detached = _arg.detached;
      if (detached && (payload == null)) {
        err = new Error("in detached mode, you must supply a payload");
        return [err, null];
      }
      msg = detached ? Buffer.concat([sig, payload]) : sig;
      r_payload = this.lib.c.crypto_sign_open(msg, this.publicKey);
      if (r_payload == null) {
        err = new Error("Signature failed to verify");
      } else if (detached) {

      } else if (payload == null) {
        payload = r_payload;
      } else if (!bufeq_secure(r_payload, payload)) {
        err = new Error("got unexpected payload");
      }
      if (err != null) {
        payload = null;
      }
      return [err, payload];
    };

    Sodium.prototype.sign = function(_arg) {
      var detached, payload, sig;
      detached = _arg.detached, payload = _arg.payload;
      sig = this.lib.c.crypto_sign(payload, this.secretKey);
      if (detached) {
        return this._detach(sig).sig;
      } else {
        return sig;
      }
    };

    Sodium.prototype.encrypt = function(_arg) {
      var nonce, plaintext, pubkey;
      plaintext = _arg.plaintext, nonce = _arg.nonce, pubkey = _arg.pubkey;
      return this._unpad(this.lib.c.crypto_box(plaintext, nonce, pubkey, this.secretKey));
    };

    Sodium.prototype.secretbox = function(_arg) {
      var nonce, plaintext;
      plaintext = _arg.plaintext, nonce = _arg.nonce;
      return this._unpad(this.lib.c.crypto_secretbox(plaintext, nonce, this.secretKey));
    };

    Sodium.prototype.decrypt = function(_arg) {
      var ciphertext, nonce, opened, pubkey;
      ciphertext = _arg.ciphertext, nonce = _arg.nonce, pubkey = _arg.pubkey;
      opened = this.lib.c.crypto_box_open(this._pad(ciphertext), nonce, pubkey, this.secretKey);
      if (!opened) {
        throw new Error('Sodium decrypt failed!');
      } else {
        return opened;
      }
    };

    Sodium.prototype.secretbox_open = function(_arg) {
      var ciphertext, nonce, opened;
      ciphertext = _arg.ciphertext, nonce = _arg.nonce;
      opened = this.lib.c.crypto_secretbox_open(this._pad(ciphertext), nonce, this.secretKey);
      if (!opened) {
        throw new Error('Sodium secretbox_open failed!');
      } else {
        return opened;
      }
    };

    Sodium.prototype.box_beforenm = function(_arg) {
      var pubkey, seckey;
      pubkey = _arg.pubkey, seckey = _arg.seckey;
      return this.lib.c.crypto_box_beforenm(pubkey, seckey);
    };

    Sodium.prototype.box_open_afternm = function(_arg) {
      var ciphertext, nonce, opened, secret;
      ciphertext = _arg.ciphertext, nonce = _arg.nonce, secret = _arg.secret;
      opened = this.lib.c.crypto_box_open_afternm(this._pad(ciphertext), nonce, secret);
      if (!opened) {
        throw new Error('Sodium box_open_afternm failed!');
      } else {
        return opened;
      }
    };

    Sodium.prototype.scalarmult_base = function(n) {
      return Buffer.from(this.lib.c.crypto_scalarmult_base(n));
    };

    Sodium.prototype.scalarmult = function(n, P) {
      return Buffer.from(this.lib.c.crypto_scalarmult(n, P));
    };

    return Sodium;

  })(Base);

}).call(this);
