"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toBePositive = toBePositive;
function toBePositive(actual) {
    // @ts-expect-error OK to have implicit any for this.utils
    const { printReceived, matcherHint } = this.utils;
    const pass = (isNumber(actual) || isBigInt(actual)) && isPositive(actual);
    return {
        pass,
        message: () => pass
            ? matcherHint('.not.toBePositive', 'received', '') +
                '\n\n' +
                'Expected value to not be positive received:\n' +
                `  ${printReceived(actual)}`
            : matcherHint('.toBePositive', 'received', '') +
                '\n\n' +
                'Expected value to be positive received:\n' +
                `  ${printReceived(actual)}`,
    };
}
const isNumber = (value) => typeof value === 'number' && !isNaN(value) && isFinite(value);
const isBigInt = (value) => typeof value === 'bigint';
const isPositive = (value) => {
    if (typeof value === 'bigint')
        return value > 0n;
    return value > 0;
};
