import { safeHandler } from '../handler';
import { isRegex } from '../regex';
import { AbstractMatcher } from './abstract-matcher';
export class SymMatcher extends AbstractMatcher {
    constructor({ value, handler }) {
        super();
        this.sym = value;
        this.handler = safeHandler(handler);
    }
    match(checkpoint) {
        let context = checkpoint.context;
        let cursor = this.seekNext(checkpoint.cursor);
        const node = cursor.node;
        if ((node === null || node === void 0 ? void 0 : node.type) === 'symbol') {
            let isMatched = true;
            if (typeof this.sym === 'string') {
                isMatched = this.sym === node.value;
            }
            else if (isRegex(this.sym)) {
                isMatched = this.sym.test(node.value);
            }
            if (isMatched) {
                context = this.handler(context, node);
                cursor = this.moveRight(cursor);
                return { cursor, context };
            }
        }
        return null;
    }
}
//# sourceMappingURL=sym-matcher.js.map