import type { StringValueToken } from '../../lexer/types';
import type { TemplateTree } from '../../parser/types';
import type { Checkpoint, Matcher, NodeHandler, StrTplOptionsBase, StrTreeHandler, StrTreeOptionsBase } from '../types';
import { AbstractMatcher } from './abstract-matcher';
export type StrContentMatcherValue = string | RegExp | null;
export type StrContentMatcherHandler<Ctx> = (ctx: Ctx, token: StringValueToken) => Ctx;
export interface StrContentMatcherOptions<Ctx> {
    value: StrContentMatcherValue;
    handler: StrContentMatcherHandler<Ctx> | null;
}
export declare class StrContentMatcher<Ctx> extends AbstractMatcher<Ctx> {
    readonly content: StrContentMatcherValue;
    readonly handler: StrContentMatcherHandler<Ctx>;
    constructor({ value, handler }: StrContentMatcherOptions<Ctx>);
    match(checkpoint: Checkpoint<Ctx>): Checkpoint<Ctx> | null;
}
interface StrTplMatcherOptions<Ctx> extends StrTplOptionsBase<Ctx> {
    matcher: Matcher<Ctx>;
}
export declare class StrTplMatcher<Ctx> extends AbstractMatcher<Ctx> {
    readonly matcher: Matcher<Ctx>;
    readonly preHandler: NodeHandler<Ctx, TemplateTree>;
    readonly postHandler: NodeHandler<Ctx, TemplateTree>;
    constructor(config: StrTplMatcherOptions<Ctx>);
    match(checkpoint: Checkpoint<Ctx>): Checkpoint<Ctx> | null;
}
export type StrNodeChildMatcher<Ctx> = StrContentMatcher<Ctx> | StrTplMatcher<Ctx>;
export interface StrMatcherOptions<Ctx> extends StrTreeOptionsBase<Ctx> {
    matchers: StrNodeChildMatcher<Ctx>[] | null;
}
export declare class StrNodeMatcher<Ctx> extends AbstractMatcher<Ctx> {
    matchers: StrNodeChildMatcher<Ctx>[] | null;
    readonly preHandler: StrTreeHandler<Ctx>;
    readonly postHandler: StrTreeHandler<Ctx>;
    constructor(opts: StrMatcherOptions<Ctx>);
    match(checkpoint: Checkpoint<Ctx>): Checkpoint<Ctx> | null;
}
export {};
//# sourceMappingURL=str-matcher.d.ts.map