import { AbstractMatcher } from './abstract-matcher';
export class SeqMatcher extends AbstractMatcher {
    constructor({ matchers }) {
        super();
        this.checkpoint = null;
        this.idx = 0;
        this.seq = matchers;
        this.length = this.seq.length;
    }
    isMatchingComplete() {
        return this.idx === this.length;
    }
    matchForward() {
        if (this.checkpoint) {
            while (this.idx < this.length) {
                const matcher = this.seq[this.idx];
                const checkpoint = matcher.match(this.checkpoint);
                if (!checkpoint) {
                    break;
                }
                this.checkpoint = checkpoint;
                this.idx += 1;
            }
            if (this.isMatchingComplete()) {
                return this.checkpoint;
            }
        }
        return null;
    }
    backtrack() {
        while (this.idx > 0) {
            this.idx -= 1;
            const matcher = this.seq[this.idx];
            const match = matcher.nextMatch();
            if (match) {
                this.checkpoint = match;
                this.idx += 1;
                return match;
            }
        }
        return null;
    }
    match(checkpoint) {
        this.idx = 0;
        this.checkpoint = checkpoint;
        while (!this.isMatchingComplete()) {
            const forwardMatch = this.matchForward();
            if (!forwardMatch) {
                const backwardMatch = this.backtrack();
                if (!backwardMatch) {
                    return null;
                }
            }
        }
        return this.checkpoint;
    }
    nextMatch() {
        if (!this.backtrack()) {
            return null;
        }
        while (!this.isMatchingComplete()) {
            const forwardMatch = this.matchForward();
            if (!forwardMatch) {
                const backwardMatch = this.backtrack();
                if (!backwardMatch) {
                    return null;
                }
            }
        }
        return this.checkpoint;
    }
}
//# sourceMappingURL=seq-matcher.js.map