import { safeHandler } from '../handler';
import { isRegex } from '../regex';
import { AbstractMatcher } from './abstract-matcher';
export class NumMatcher extends AbstractMatcher {
    constructor({ value, handler }) {
        super();
        this.num = value;
        this.handler = safeHandler(handler);
    }
    match(checkpoint) {
        let context = checkpoint.context;
        let cursor = this.seekNext(checkpoint.cursor);
        const node = cursor.node;
        if ((node === null || node === void 0 ? void 0 : node.type) === 'number') {
            let isMatched = true;
            if (typeof this.num === 'string') {
                isMatched = this.num === node.value;
            }
            else if (isRegex(this.num)) {
                isMatched = this.num.test(node.value);
            }
            if (isMatched) {
                context = this.handler(context, node);
                cursor = this.moveRight(cursor);
                return { cursor, context };
            }
        }
        return null;
    }
}
//# sourceMappingURL=num-matcher.js.map