import { safeHandler } from '../handler';
import { isRegex } from '../regex';
import { AbstractMatcher } from './abstract-matcher';
const skipBeforeComment = ['whitespace', '_start', 'newline'];
export class CommentMatcher extends AbstractMatcher {
    constructor({ value, handler }) {
        super();
        this.comment = value;
        this.handler = safeHandler(handler);
    }
    canSkip(node) {
        return skipBeforeComment.includes(node.type);
    }
    match(checkpoint) {
        var _a;
        const context = checkpoint.context;
        const cursor = this.seekNext(checkpoint.cursor);
        const node = cursor.node;
        if ((node === null || node === void 0 ? void 0 : node.type) === 'comment') {
            let isMatched = true;
            if (typeof this.comment === 'string') {
                isMatched = this.comment === node.value;
            }
            else if (isRegex(this.comment)) {
                isMatched = this.comment.test(node.value);
            }
            if (isMatched) {
                const nextContext = this.handler(context, node);
                const nextCursor = (_a = cursor.right) !== null && _a !== void 0 ? _a : cursor;
                return { context: nextContext, cursor: nextCursor };
            }
        }
        return null;
    }
}
//# sourceMappingURL=comment-matcher.js.map