import { clone } from '../../util/clone';
import { AbstractMatcher } from './abstract-matcher';
export class BeginMatcher extends AbstractMatcher {
    match(checkpoint) {
        var _a;
        let { cursor } = checkpoint;
        if (((_a = cursor.node) === null || _a === void 0 ? void 0 : _a.type) === '_start') {
            cursor = this.moveRight(cursor);
            return { ...checkpoint, cursor };
        }
        return null;
    }
}
export class EndMatcher extends AbstractMatcher {
    match(checkpoint) {
        var _a;
        let { cursor } = checkpoint;
        cursor = this.seekNext(cursor);
        if (((_a = cursor.node) === null || _a === void 0 ? void 0 : _a.type) === '_end') {
            return checkpoint;
        }
        return null;
    }
}
export class VoidMatcher extends AbstractMatcher {
    constructor(handler) {
        super();
        this.handler = (context, t) => handler(clone(context), t);
    }
    match(checkpoint) {
        var _a;
        const { cursor, context } = checkpoint;
        const prevCursor = (_a = cursor.left) !== null && _a !== void 0 ? _a : cursor;
        const node = prevCursor.node;
        const newContext = this.handler(context, node);
        return { cursor, context: newContext };
    }
    moveRight(cursor) {
        return cursor;
    }
    seekNext(cursor) {
        return cursor;
    }
}
//# sourceMappingURL=anchor-matcher.js.map