import type { Token } from '../../lexer/types';
import type { Cursor, Tree } from '../../parser';
import type { Checkpoint } from '../types';
import { AbstractMatcher } from './abstract-matcher';
export declare class BeginMatcher<Ctx> extends AbstractMatcher<Ctx> {
    match(checkpoint: Checkpoint<Ctx>): Checkpoint<Ctx> | null;
}
export declare class EndMatcher<Ctx> extends AbstractMatcher<Ctx> {
    match(checkpoint: Checkpoint<Ctx>): Checkpoint<Ctx> | null;
}
export declare class VoidMatcher<Ctx, T extends Tree | Token> extends AbstractMatcher<Ctx> {
    private handler;
    constructor(handler: (context: Ctx, t: T) => Ctx);
    match(checkpoint: Checkpoint<Ctx>): Checkpoint<Ctx> | null;
    moveRight(cursor: Cursor): Cursor;
    seekNext(cursor: Cursor): Cursor;
}
//# sourceMappingURL=anchor-matcher.d.ts.map