export function isBracketKey(key) {
    return key.startsWith('bracket$');
}
export function isLeftKey(key) {
    return key.endsWith('$left');
}
export function isRightKey(key) {
    return key.endsWith('$right');
}
export function getCounterpartBracketKey(rightKey) {
    const [tokenName, idx, side] = rightKey.split('$');
    const sides = new Set(['left', 'right']);
    let result;
    if (tokenName === 'bracket' && typeof side === 'string' && sides.has(side)) {
        sides.delete(side);
        const [counterpart] = [...sides];
        result = [tokenName, idx, counterpart].join('$');
    }
    return result;
}
export function configBrackets(states, opts) {
    const bracketDefs = {};
    opts.forEach((option, idx) => {
        const tokenKey = `bracket$${idx}`;
        const leftTokenKey = `${tokenKey}$left`;
        const leftTokenRule = {
            t: 'string',
            type: leftTokenKey,
            match: option.startsWith,
            chunk: option.startsWith,
        };
        const rightTokenKey = `${tokenKey}$right`;
        const rightTokenRule = {
            t: 'string',
            type: rightTokenKey,
            match: option.endsWith,
            chunk: option.endsWith,
        };
        bracketDefs[leftTokenKey] = leftTokenRule;
        bracketDefs[rightTokenKey] = rightTokenRule;
    });
    return {
        ...states,
        $: {
            ...states.$,
            ...bracketDefs,
        },
    };
}
//# sourceMappingURL=bracket.js.map