import { createLexer } from '../lexer';
import { createCursor, createTree } from '../parser';
import { buildRoot } from '../query';
import { clone } from '../util/clone';
import { lang as groovy } from './groovy';
import { lang as python } from './python';
import { lang as scala } from './scala';
import { lang as starlark } from './starlark';
export * from './types';
export class Language {
    constructor(config) {
        this.config = config;
        this.lexer = createLexer(config.lexer);
    }
    parse(input) {
        this.lexer.reset(input);
        const root = createTree(this.lexer, this.config.parser);
        return createCursor(root);
    }
    query(input, q, context) {
        const matcher = buildRoot(q);
        const cursor = typeof input === 'string' ? this.parse(input) : input;
        const checkpoint = matcher.match({ cursor, context });
        const result = checkpoint === null || checkpoint === void 0 ? void 0 : checkpoint.context;
        return result ? clone(result) : null;
    }
}
const languagePresets = {
    groovy,
    python,
    scala,
    starlark,
};
export function createLang(arg1) {
    const config = typeof arg1 === 'string' ? languagePresets[arg1] : arg1;
    return new Language(config);
}
//# sourceMappingURL=index.js.map