"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.coerceStrOptions = exports.coerceTreeOptions = exports.coerceManyOptions = exports.coerceNumOptions = exports.coerceCommentOptions = exports.coerceOpOptions = exports.coerceSymOptions = void 0;
const regex_1 = require("./regex");
function coerceSymOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || (0, regex_1.isRegex)(arg1)) {
        return {
            value: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    if (typeof arg1 === 'function') {
        return {
            value: null,
            handler: arg1,
        };
    }
    if (arg1 !== null && typeof arg1 === 'object') {
        return arg1;
    }
    return { value: null, handler: null };
}
exports.coerceSymOptions = coerceSymOptions;
function coerceOpOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || (0, regex_1.isRegex)(arg1)) {
        return {
            value: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    if (typeof arg1 === 'function') {
        return {
            value: null,
            handler: arg1,
        };
    }
    if (arg1 !== null && typeof arg1 === 'object') {
        return arg1;
    }
    return { value: null, handler: null };
}
exports.coerceOpOptions = coerceOpOptions;
function coerceCommentOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || (0, regex_1.isRegex)(arg1)) {
        return {
            value: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    if (typeof arg1 === 'function') {
        return {
            value: null,
            handler: arg1,
        };
    }
    if (arg1 !== null && typeof arg1 === 'object') {
        return arg1;
    }
    return { value: null, handler: null };
}
exports.coerceCommentOptions = coerceCommentOptions;
function coerceNumOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || (0, regex_1.isRegex)(arg1)) {
        return {
            value: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    if (typeof arg1 === 'function') {
        return {
            value: null,
            handler: arg1,
        };
    }
    if (arg1 !== null && typeof arg1 === 'object') {
        return arg1;
    }
    return { value: null, handler: null };
}
exports.coerceNumOptions = coerceNumOptions;
function coerceManyOptions(builder, arg2, arg3) {
    if (typeof arg2 === 'number' && typeof arg3 === 'number') {
        return { builder, min: arg2, max: arg3 };
    }
    return { builder, min: 1, max: null };
}
exports.coerceManyOptions = coerceManyOptions;
function coerceTreeOptions(arg1) {
    if (typeof arg1 === 'string') {
        return { type: arg1 };
    }
    else if (!arg1) {
        return { type: null };
    }
    else {
        return arg1;
    }
}
exports.coerceTreeOptions = coerceTreeOptions;
function coerceStrOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || (0, regex_1.isRegex)(arg1)) {
        if (arg1 === '') {
            return {
                type: 'str-tree',
                match: [],
                postHandler: arg2
                    ? (ctx, tree) => arg2(ctx, {
                        ...tree.startsWith,
                        type: 'string-value',
                        value: arg1,
                    })
                    : null,
            };
        }
        return {
            type: 'str-content',
            match: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    else if (typeof arg1 === 'function') {
        return {
            type: 'str-content',
            match: null,
            handler: arg1,
        };
    }
    else if (arg1) {
        if (arg1['handler'] ||
            typeof arg1.match === 'string' ||
            (0, regex_1.isRegex)(arg1.match)) {
            return {
                type: 'str-content',
                ...arg1,
            };
        }
        return {
            type: 'str-tree',
            ...arg1,
        };
    }
    return {
        type: 'str-tree',
        match: null,
        preHandler: null,
        postHandler: null,
    };
}
exports.coerceStrOptions = coerceStrOptions;
//# sourceMappingURL=options.js.map