"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SymMatcher = void 0;
const handler_1 = require("../handler");
const regex_1 = require("../regex");
const abstract_matcher_1 = require("./abstract-matcher");
class SymMatcher extends abstract_matcher_1.AbstractMatcher {
    constructor({ value, handler }) {
        super();
        this.sym = value;
        this.handler = (0, handler_1.safeHandler)(handler);
    }
    match(checkpoint) {
        let context = checkpoint.context;
        let cursor = this.seekNext(checkpoint.cursor);
        const node = cursor.node;
        if ((node === null || node === void 0 ? void 0 : node.type) === 'symbol') {
            let isMatched = true;
            if (typeof this.sym === 'string') {
                isMatched = this.sym === node.value;
            }
            else if ((0, regex_1.isRegex)(this.sym)) {
                isMatched = this.sym.test(node.value);
            }
            if (isMatched) {
                context = this.handler(context, node);
                cursor = this.moveRight(cursor);
                return { cursor, context };
            }
        }
        return null;
    }
}
exports.SymMatcher = SymMatcher;
//# sourceMappingURL=sym-matcher.js.map