"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SeqMatcher = void 0;
const abstract_matcher_1 = require("./abstract-matcher");
class SeqMatcher extends abstract_matcher_1.AbstractMatcher {
    constructor({ matchers }) {
        super();
        this.checkpoint = null;
        this.idx = 0;
        this.seq = matchers;
        this.length = this.seq.length;
    }
    isMatchingComplete() {
        return this.idx === this.length;
    }
    matchForward() {
        if (this.checkpoint) {
            while (this.idx < this.length) {
                const matcher = this.seq[this.idx];
                const checkpoint = matcher.match(this.checkpoint);
                if (!checkpoint) {
                    break;
                }
                this.checkpoint = checkpoint;
                this.idx += 1;
            }
            if (this.isMatchingComplete()) {
                return this.checkpoint;
            }
        }
        return null;
    }
    backtrack() {
        while (this.idx > 0) {
            this.idx -= 1;
            const matcher = this.seq[this.idx];
            const match = matcher.nextMatch();
            if (match) {
                this.checkpoint = match;
                this.idx += 1;
                return match;
            }
        }
        return null;
    }
    match(checkpoint) {
        this.idx = 0;
        this.checkpoint = checkpoint;
        while (!this.isMatchingComplete()) {
            const forwardMatch = this.matchForward();
            if (!forwardMatch) {
                const backwardMatch = this.backtrack();
                if (!backwardMatch) {
                    return null;
                }
            }
        }
        return this.checkpoint;
    }
    nextMatch() {
        if (!this.backtrack()) {
            return null;
        }
        while (!this.isMatchingComplete()) {
            const forwardMatch = this.matchForward();
            if (!forwardMatch) {
                const backwardMatch = this.backtrack();
                if (!backwardMatch) {
                    return null;
                }
            }
        }
        return this.checkpoint;
    }
}
exports.SeqMatcher = SeqMatcher;
//# sourceMappingURL=seq-matcher.js.map