"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NumMatcher = void 0;
const handler_1 = require("../handler");
const regex_1 = require("../regex");
const abstract_matcher_1 = require("./abstract-matcher");
class NumMatcher extends abstract_matcher_1.AbstractMatcher {
    constructor({ value, handler }) {
        super();
        this.num = value;
        this.handler = (0, handler_1.safeHandler)(handler);
    }
    match(checkpoint) {
        let context = checkpoint.context;
        let cursor = this.seekNext(checkpoint.cursor);
        const node = cursor.node;
        if ((node === null || node === void 0 ? void 0 : node.type) === 'number') {
            let isMatched = true;
            if (typeof this.num === 'string') {
                isMatched = this.num === node.value;
            }
            else if ((0, regex_1.isRegex)(this.num)) {
                isMatched = this.num.test(node.value);
            }
            if (isMatched) {
                context = this.handler(context, node);
                cursor = this.moveRight(cursor);
                return { cursor, context };
            }
        }
        return null;
    }
}
exports.NumMatcher = NumMatcher;
//# sourceMappingURL=num-matcher.js.map