"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommentMatcher = void 0;
const handler_1 = require("../handler");
const regex_1 = require("../regex");
const abstract_matcher_1 = require("./abstract-matcher");
const skipBeforeComment = ['whitespace', '_start', 'newline'];
class CommentMatcher extends abstract_matcher_1.AbstractMatcher {
    constructor({ value, handler }) {
        super();
        this.comment = value;
        this.handler = (0, handler_1.safeHandler)(handler);
    }
    canSkip(node) {
        return skipBeforeComment.includes(node.type);
    }
    match(checkpoint) {
        var _a;
        const context = checkpoint.context;
        const cursor = this.seekNext(checkpoint.cursor);
        const node = cursor.node;
        if ((node === null || node === void 0 ? void 0 : node.type) === 'comment') {
            let isMatched = true;
            if (typeof this.comment === 'string') {
                isMatched = this.comment === node.value;
            }
            else if ((0, regex_1.isRegex)(this.comment)) {
                isMatched = this.comment.test(node.value);
            }
            if (isMatched) {
                const nextContext = this.handler(context, node);
                const nextCursor = (_a = cursor.right) !== null && _a !== void 0 ? _a : cursor;
                return { context: nextContext, cursor: nextCursor };
            }
        }
        return null;
    }
}
exports.CommentMatcher = CommentMatcher;
//# sourceMappingURL=comment-matcher.js.map