"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VoidMatcher = exports.EndMatcher = exports.BeginMatcher = void 0;
const clone_1 = require("../../util/clone");
const abstract_matcher_1 = require("./abstract-matcher");
class BeginMatcher extends abstract_matcher_1.AbstractMatcher {
    match(checkpoint) {
        var _a;
        let { cursor } = checkpoint;
        if (((_a = cursor.node) === null || _a === void 0 ? void 0 : _a.type) === '_start') {
            cursor = this.moveRight(cursor);
            return { ...checkpoint, cursor };
        }
        return null;
    }
}
exports.BeginMatcher = BeginMatcher;
class EndMatcher extends abstract_matcher_1.AbstractMatcher {
    match(checkpoint) {
        var _a;
        let { cursor } = checkpoint;
        cursor = this.seekNext(cursor);
        if (((_a = cursor.node) === null || _a === void 0 ? void 0 : _a.type) === '_end') {
            return checkpoint;
        }
        return null;
    }
}
exports.EndMatcher = EndMatcher;
class VoidMatcher extends abstract_matcher_1.AbstractMatcher {
    constructor(handler) {
        super();
        this.handler = (context, t) => handler((0, clone_1.clone)(context), t);
    }
    match(checkpoint) {
        var _a;
        const { cursor, context } = checkpoint;
        const prevCursor = (_a = cursor.left) !== null && _a !== void 0 ? _a : cursor;
        const node = prevCursor.node;
        const newContext = this.handler(context, node);
        return { cursor, context: newContext };
    }
    moveRight(cursor) {
        return cursor;
    }
    seekNext(cursor) {
        return cursor;
    }
}
exports.VoidMatcher = VoidMatcher;
//# sourceMappingURL=anchor-matcher.js.map