"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configOperators = void 0;
function configOperators(states, operators) {
    const operatorRules = {};
    operators.map((op, idx) => {
        const tokenName = `op$${idx}`;
        const tokenRule = {
            t: 'string',
            type: tokenName,
            match: op,
            chunk: op,
        };
        operatorRules[tokenName] = tokenRule;
    });
    return {
        ...states,
        $: {
            ...states.$,
            ...operatorRules,
        },
    };
}
exports.configOperators = configOperators;
//# sourceMappingURL=operator.js.map