"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLexer = exports.configureLexerRules = void 0;
const moo_1 = require("moo");
const bracket_1 = require("./bracket");
const comment_1 = require("./comment");
const number_1 = require("./number");
const operator_1 = require("./operator");
const rules_1 = require("./rules");
const string_1 = require("./string");
const symbol_1 = require("./symbol");
const token_1 = require("./token");
__exportStar(require("./token"), exports);
__exportStar(require("./types"), exports);
function configureLexerRules(lexerConfig) {
    const whitespace = lexerConfig.joinLines
        ? {
            t: 'regex',
            type: 'whitespace',
            match: new RegExp(`(?:${lexerConfig.joinLines}\\r?\\n|[ \\t\\r])+`),
            lineBreaks: true,
            chunk: null,
        }
        : {
            t: 'regex',
            type: 'whitespace',
            match: /[ \t\r]+/,
            chunk: null,
        };
    let result = {
        $: {
            whitespace,
            newline: {
                t: 'regex',
                type: 'newline',
                match: /\r?\n/,
                chunk: null,
                lineBreaks: true,
            },
            _: { ...rules_1.fallbackRule, type: '_' },
        },
    };
    const { comments, symbols, operators, brackets, strings, numbers } = lexerConfig;
    result = (0, comment_1.configComments)(result, comments);
    result = (0, symbol_1.configSymbols)(result, { match: symbols });
    result = (0, operator_1.configOperators)(result, operators);
    result = (0, bracket_1.configBrackets)(result, brackets);
    result = (0, string_1.configStrings)(result, strings);
    result = (0, number_1.configNumbers)(result, { match: numbers });
    const orderedResult = (0, rules_1.createOrderedStateMap)(result);
    return orderedResult;
}
exports.configureLexerRules = configureLexerRules;
function isVarToken(key) {
    return typeof key === 'string' && /^str\$\d+\$tpl\$\d+\$token$/.test(key);
}
function getVarEndToken({ type, value, offset, line, col, lineBreaks, }) {
    return {
        type: type === null || type === void 0 ? void 0 : type.replace(/\$[^$]+$/, '$end'),
        value: '',
        text: '',
        offset: offset + value.length,
        line: line + lineBreaks,
        col: col + value.length,
        lineBreaks: 0,
    };
}
function getSubLexers(states) {
    const result = {};
    for (const [key, rules] of Object.entries(states)) {
        if (isVarToken(key)) {
            result[key] = (0, moo_1.compile)(rules);
        }
    }
    return result;
}
function createLexer(options) {
    const rules = configureLexerRules(options);
    const subLexers = getSubLexers(rules);
    const mainLexer = (0, moo_1.states)(rules);
    let subLexer;
    let subLexerToken;
    const result = {
        reset(input) {
            Object.values(subLexers).forEach((subLexer) => subLexer.reset());
            subLexer = undefined;
            subLexerToken = undefined;
            if (typeof input === 'undefined' || input === null) {
                mainLexer.reset();
            }
            else {
                mainLexer.reset(input);
            }
            return result;
        },
        [Symbol.iterator]() {
            const next = () => {
                const mooLexer = subLexer !== null && subLexer !== void 0 ? subLexer : mainLexer;
                const mooIter = mooLexer[Symbol.iterator]();
                const nextElem = mooIter.next();
                if (nextElem.done) {
                    if (subLexer && subLexerToken) {
                        const subLexerType = subLexerToken.type;
                        mooLexer.reset();
                        if (isVarToken(subLexerType)) {
                            const x = getVarEndToken(subLexerToken);
                            const value = (0, token_1.coerceToken)(x);
                            subLexer = undefined;
                            subLexerToken = undefined;
                            return { done: false, value };
                        }
                        else {
                            subLexer = undefined;
                            subLexerToken = undefined;
                            return next();
                        }
                    }
                    else {
                        return { done: true, value: null };
                    }
                }
                const mooToken = nextElem.value;
                if (!subLexer) {
                    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                    const mooTokenType = mooToken.type;
                    subLexer = subLexers[mooTokenType];
                    if (subLexer) {
                        subLexerToken = mooToken;
                        subLexer.reset(mooToken.value);
                        return next();
                    }
                }
                const value = (0, token_1.coerceToken)(mooToken, subLexerToken);
                return { done: false, value };
            };
            return { next };
        },
    };
    return result;
}
exports.createLexer = createLexer;
//# sourceMappingURL=index.js.map