"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configBrackets = exports.getCounterpartBracketKey = exports.isRightKey = exports.isLeftKey = exports.isBracketKey = void 0;
function isBracketKey(key) {
    return key.startsWith('bracket$');
}
exports.isBracketKey = isBracketKey;
function isLeftKey(key) {
    return key.endsWith('$left');
}
exports.isLeftKey = isLeftKey;
function isRightKey(key) {
    return key.endsWith('$right');
}
exports.isRightKey = isRightKey;
function getCounterpartBracketKey(rightKey) {
    const [tokenName, idx, side] = rightKey.split('$');
    const sides = new Set(['left', 'right']);
    let result;
    if (tokenName === 'bracket' && typeof side === 'string' && sides.has(side)) {
        sides.delete(side);
        const [counterpart] = [...sides];
        result = [tokenName, idx, counterpart].join('$');
    }
    return result;
}
exports.getCounterpartBracketKey = getCounterpartBracketKey;
function configBrackets(states, opts) {
    const bracketDefs = {};
    opts.forEach((option, idx) => {
        const tokenKey = `bracket$${idx}`;
        const leftTokenKey = `${tokenKey}$left`;
        const leftTokenRule = {
            t: 'string',
            type: leftTokenKey,
            match: option.startsWith,
            chunk: option.startsWith,
        };
        const rightTokenKey = `${tokenKey}$right`;
        const rightTokenRule = {
            t: 'string',
            type: rightTokenKey,
            match: option.endsWith,
            chunk: option.endsWith,
        };
        bracketDefs[leftTokenKey] = leftTokenRule;
        bracketDefs[rightTokenKey] = rightTokenRule;
    });
    return {
        ...states,
        $: {
            ...states.$,
            ...bracketDefs,
        },
    };
}
exports.configBrackets = configBrackets;
//# sourceMappingURL=bracket.js.map