"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lang = exports.parser = exports.lexer = void 0;
/**
 * @see https://github.com/bazelbuild/starlark/blob/master/spec.md#lexical-elements
 */
const operators = 
/* prettier-ignore */ [
    '+', '-', '*', '//', '%', '**',
    '~', '&', '|', '^', '<<', '>>',
    '.', ',', '=', ';', ':',
    '<', '>', '>=', '<=', '==', '!=',
    '+=', '-=', '*=', '//=', '%=',
    '&=', '|=', '^=', '<<=', '>>=',
];
const octdigit = '[0-7]';
const digit = '[0-9]';
const nonzerodigit = '[1-9]';
const hexdigit = `(?:${digit}|[a-fA-F])`;
const octinteger = `(?:0[oO](?:_?${octdigit})+)`;
const hexinteger = `(?:0[xX](?:_?${hexdigit})+)`;
const decinteger = `(?:${nonzerodigit}(?:_?${digit})*|0+(?:_?0)*)`;
const integer = `(?:${decinteger}|${octinteger}|${hexinteger})`;
const digitpart = `(?:${digit}(?:_?${digit})*)`;
const fraction = `(?:\\.${digitpart})`;
const exponent = `(?:[eE][-+]?${digitpart})`;
const pointfloat = `(?:${digitpart}?${fraction}|${digitpart}\\.)`;
const exponentfloat = `(?:(?:${digitpart}|${pointfloat})${exponent})`;
const floatnumber = `(?:${pointfloat}|${exponentfloat})`;
const numbers = new RegExp(`(?:${integer}|${floatnumber})`);
exports.lexer = {
    joinLines: '\\',
    comments: [{ type: 'line-comment', startsWith: '#' }],
    symbols: /[_a-zA-Z][_a-zA-Z0-9]*/,
    numbers,
    operators,
    brackets: [
        { startsWith: '{', endsWith: '}' },
        { startsWith: '[', endsWith: ']' },
        { startsWith: '(', endsWith: ')' },
    ],
    strings: [
        { startsWith: "'" },
        { startsWith: '"' },
        { startsWith: "'''" },
        { startsWith: '"""' },
        { startsWith: "r'", endsWith: "'" },
        { startsWith: 'r"', endsWith: '"' },
        { startsWith: "rb'", endsWith: "'" },
        { startsWith: 'rb"', endsWith: '"' },
        { startsWith: "br'", endsWith: "'" },
        { startsWith: 'br"', endsWith: '"' },
    ],
};
exports.parser = {
    useIndentBlocks: true,
};
exports.lang = { lexer: exports.lexer, parser: exports.parser };
//# sourceMappingURL=starlark.js.map