import type { Cursor, Node } from '../parser/types';
import type { QueryBuilder } from '../query/types';
import type { LanguageConfig } from './types';
export * from './types';
export declare class Language {
    readonly config: LanguageConfig;
    private lexer;
    constructor(config: LanguageConfig);
    parse(input: string): Cursor;
    query<Ctx, T extends Node>(input: string | Cursor, q: QueryBuilder<Ctx, T>, context: Ctx): Ctx | null;
}
declare const languagePresets: {
    groovy: LanguageConfig;
    python: LanguageConfig;
    scala: LanguageConfig;
    starlark: LanguageConfig;
};
type LanguagePreset = keyof typeof languagePresets;
export declare function createLang(key: LanguagePreset): Language;
export declare function createLang(config: LanguageConfig): Language;
//# sourceMappingURL=index.d.ts.map