"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.findPackages = void 0;
const path_1 = __importDefault(require("path"));
const read_project_manifest_1 = require("@pnpm/read-project-manifest");
const util_lex_comparator_1 = require("@pnpm/util.lex-comparator");
const fast_glob_1 = __importDefault(require("fast-glob"));
const p_filter_1 = __importDefault(require("p-filter"));
const DEFAULT_IGNORE = [
    '**/node_modules/**',
    '**/bower_components/**',
    '**/test/**',
    '**/tests/**',
];
async function findPackages(root, opts) {
    opts = opts ?? {};
    const globOpts = { ...opts, cwd: root, includeRoot: undefined };
    globOpts.ignore = opts.ignore ?? DEFAULT_IGNORE;
    const patterns = normalizePatterns((opts.patterns != null) ? opts.patterns : ['.', '**']);
    const paths = await (0, fast_glob_1.default)(patterns, globOpts);
    if (opts.includeRoot) {
        // Always include the workspace root (https://github.com/pnpm/pnpm/issues/1986)
        Array.prototype.push.apply(paths, await (0, fast_glob_1.default)(normalizePatterns(['.']), globOpts));
    }
    return (0, p_filter_1.default)(
    // `Array.from()` doesn't create an intermediate instance,
    // unlike `array.map()`
    Array.from(
    // Remove duplicate paths using `Set`
    new Set(paths
        .map(manifestPath => path_1.default.join(root, manifestPath))
        .sort((path1, path2) => (0, util_lex_comparator_1.lexCompare)(path_1.default.dirname(path1), path_1.default.dirname(path2)))), async (manifestPath) => {
        try {
            return {
                dir: path_1.default.dirname(manifestPath),
                ...await (0, read_project_manifest_1.readExactProjectManifest)(manifestPath),
            };
        }
        catch (err) { // eslint-disable-line
            if (err.code === 'ENOENT') {
                return null;
            }
            throw err;
        }
    }), Boolean);
}
exports.findPackages = findPackages;
function normalizePatterns(patterns) {
    const normalizedPatterns = [];
    for (const pattern of patterns) {
        // We should add separate pattern for each extension
        // for some reason, fast-glob is buggy with /package.{json,yaml,json5} pattern
        normalizedPatterns.push(pattern.replace(/\/?$/, '/package.json'));
        normalizedPatterns.push(pattern.replace(/\/?$/, '/package.json5'));
        normalizedPatterns.push(pattern.replace(/\/?$/, '/package.yaml'));
    }
    return normalizedPatterns;
}
//# sourceMappingURL=index.js.map