"use strict";
exports.__esModule = true;
exports.throwsErrorOfType = void 0;
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is a `Function` which throws an `Error` of the given
 * type.
 * @param typeName 'TypeError'
 * @param value () => thisValueIsUndefined.someProp
 * @matcherName toThrowErrorOfType
 * @memberMatcherName toHaveMethodThrowingErrorOfType
 * @matcherMessage expected ${value} to throw an error of type ${typeName}
 * @matcherNotMessage expected ${value} not to throw an error of type
 * ${typeName}
 */
exports.throwsErrorOfType = (0, curry2_1.curry2)(function (typeName, value) {
    try {
        value();
        return false;
    }
    catch (err) {
        return err.name === typeName;
    }
});
