"use strict";
exports.__esModule = true;
exports.isNegativeNumber = void 0;
var is_number_1 = require("./is-number");
/**
 * Asserts that a value is a `Number` less than 0.
 * @param value -18
 * @matcherName toBeNegativeNumber
 * @memberMatcherName toHaveNegativeNumber
 * @matcherMessage expected ${value} to be a negative number
 * @matcherNotMessage expected ${value} not to be a negative number
 */
var isNegativeNumber = function (value) { return (0, is_number_1.isNumber)(value) && value < 0; };
exports.isNegativeNumber = isNegativeNumber;
