"use strict";
exports.__esModule = true;
exports.isLongerThan = void 0;
var curry2_1 = require("./lib/curry2");
var is_indexed_list_1 = require("./lib/is-indexed-list");
/**
 * Asserts that a value is a `String` or `Array` whose length is greater than
 * that of another.
 * @param other [2, 'items']
 * @param value ['i', 'have', 3]
 * @matcherName toBeLongerThan
 * @memberMatcherName toHaveLongerThan
 * @matcherMessage expected ${value} to be a string or array whose length is
 * greater than that of ${other}
 * @matcherNotMessage expected ${value} not to be a string or array whose length
 * is greater than that of ${other}
 */
exports.isLongerThan = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_indexed_list_1.isIndexedList)(value) && (0, is_indexed_list_1.isIndexedList)(other) && value.length > other.length;
});
