"use strict";
exports.__esModule = true;
exports.isLessThanOrEqualTo = void 0;
var is_number_1 = require("./is-number");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is less than or equal to another.
 * @param other 12
 * @param value 8
 * @matcherName toBeLessThanOrEqualTo
 * @memberMatcherName toHaveLessThanOrEqualTo
 * @matcherMessage expected ${value} to be less than or equal to ${other}
 * @matcherNotMessage expected ${value} not to be less than or equal to ${other}
 */
exports.isLessThanOrEqualTo = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_number_1.isNumber)(value) && (0, is_number_1.isNumber)(other) && value <= other;
});
