"use strict";
exports.__esModule = true;
exports.isJsonString = void 0;
var is_string_1 = require("./is-string");
/**
 * Asserts that a value is a `String` of valid JSON.
 * @param value '{"i":"am valid JSON"}'
 * @matcherName toBeJsonString
 * @memberMatcherName toHaveJsonString
 * @matcherMessage expected ${value} to be a string of valid JSON
 * @matcherNotMessage expected ${value} not to be a string of valid JSON
 */
var isJsonString = function (value) {
    try {
        return (0, is_string_1.isString)(value) && JSON.parse(value) !== null;
    }
    catch (err) {
        return false;
    }
};
exports.isJsonString = isJsonString;
