"use strict";
exports.__esModule = true;
exports.isEmptyString = void 0;
var is_string_1 = require("./is-string");
/**
 * Asserts that a value is a valid `String` containing no characters.
 * @param value ''
 * @matcherName toBeEmptyString
 * @memberMatcherName toHaveEmptyString
 * @matcherMessage expected ${value} to be an empty string or empty instance of
 * String
 * @matcherNotMessage expected ${value} not to be an empty string or empty
 * instance of String
 */
var isEmptyString = function (value) { return (0, is_string_1.isString)(value) && value.length === 0; };
exports.isEmptyString = isEmptyString;
