"use strict";
exports.__esModule = true;
exports.isDivisibleBy = void 0;
var is_number_1 = require("./is-number");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is a `Number` which results in a whole number when
 * divided by another.
 * @param other 2
 * @param value 12
 * @matcherName toBeDivisibleBy
 * @memberMatcherName toHaveDivisibleBy
 * @matcherMessage expected ${value} to be divisible by ${other}
 * @matcherNotMessage expected ${value} not to be divisible by ${other}
 */
exports.isDivisibleBy = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_number_1.isNumber)(value) && (0, is_number_1.isNumber)(other) && value % other === 0;
});
