"use strict";
exports.__esModule = true;
exports.isDateOnDayOfWeek = void 0;
var is_date_1 = require("./is-date");
var is_number_1 = require("./is-number");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is an instance of `Date` occurring on the day of the
 * week with the given index, where Sunday is `0` and Saturday is `6`.
 * @param index 0
 * @param value new Date('2021-08-29')
 * @matcherName toBeDateOnDayOfWeek
 * @memberMatcherName toHaveDateOnDayOfWeek
 * @matcherMessage expected ${value} to be an instance of Date occurring on the
 * day of the week with index ${index}
 * @matcherNotMessage expected ${value} not to be an instance of Date occurring
 * on the day of the week with index ${index}
 */
exports.isDateOnDayOfWeek = (0, curry2_1.curry2)(function (index, value) {
    return (0, is_date_1.isDate)(value) && (0, is_number_1.isNumber)(index) && value.getDay() === index;
});
